/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.lambda.function;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.dromara.stream.core.lambda.LambdaInvokeException;

@FunctionalInterface
public interface SerBiOp<T>
extends BinaryOperator<T>,
Serializable {
    public T applying(T var1, T var2) throws Throwable;

    @Override
    default public T apply(T t, T u) {
        try {
            return this.applying(t, u);
        }
        catch (Throwable e) {
            throw new LambdaInvokeException(e);
        }
    }

    public static <T> SerBiOp<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> SerBiOp<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }

    public static <T> SerBiOp<T> justBefore() {
        return (l, r) -> l;
    }

    public static <T> SerBiOp<T> justAfter() {
        return (l, r) -> r;
    }
}

