/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.optional;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.dromara.stream.core.lambda.LambdaExecutable;
import org.dromara.stream.core.lambda.LambdaHelper;
import org.dromara.stream.core.lambda.function.SerCons;
import org.dromara.stream.core.lambda.function.SerFunc;
import org.dromara.stream.core.lambda.function.SerPred;
import org.dromara.stream.core.reflect.ReflectHelper;
import org.dromara.stream.core.stream.Steam;

public class Opp<T> {
    protected static final Opp<?> EMPTY = new Opp<Object>(null);
    protected final T value;
    protected Throwable throwable;

    protected Opp(T value) {
        this.value = value;
    }

    public static <T> Opp<T> empty() {
        Opp<?> t = EMPTY;
        return t;
    }

    public static <T> Opp<T> required(T value) {
        return new Opp<T>(Objects.requireNonNull(value));
    }

    public static <T> Opp<T> of(T value) {
        return value == null ? Opp.empty() : new Opp<T>(value);
    }

    public static <T> Opp<T> of(Optional<T> optional) {
        return Opp.of(optional).flattedMap(SerFunc.cast());
    }

    public static <T extends CharSequence> Opp<T> ofStr(T value) {
        return Opp.of(value).filter(str -> !str.toString().trim().isEmpty());
    }

    public static <T, R extends Collection<T>> Opp<R> ofColl(R value) {
        if (value == null || value.isEmpty()) {
            return Opp.empty();
        }
        for (T t : value) {
            if (t == null) continue;
            return new Opp<R>(value);
        }
        return Opp.empty();
    }

    public static <T> Opp<T> ofTry(Callable<T> callable) {
        return Opp.ofTry(callable, Throwable.class, new Class[0]);
    }

    @SafeVarargs
    public static <T> Opp<T> ofTry(Callable<T> callable, Class<? extends Throwable> exceptionType, Class<? extends Throwable> ... exceptionTypes) {
        try {
            return Opp.of(callable.call());
        }
        catch (Throwable e) {
            if (Steam.of(exceptionTypes).unshift(exceptionType).noneMatch(clazz -> clazz.isInstance(e))) {
                throw new IllegalArgumentException(e);
            }
            Opp<Object> empty = new Opp<Object>(null);
            empty.throwable = e;
            return empty;
        }
    }

    @SafeVarargs
    public static <T> Opp<T> notTry(Callable<T> callable, Class<? extends Throwable> ... exceptionTypes) {
        try {
            return Opp.of(callable.call());
        }
        catch (Throwable e) {
            if (Steam.of(exceptionTypes).anyMatch(clazz -> clazz.isInstance(e))) {
                throw new IllegalArgumentException(e);
            }
            Opp<Object> empty = new Opp<Object>(null);
            empty.throwable = e;
            return empty;
        }
    }

    public T get() {
        return this.value;
    }

    public <R> R get(Function<T, R> mapper) {
        return this.map(mapper).orElse(null);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isFail() {
        return null != this.throwable;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Opp<T> ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.value);
        }
        return this;
    }

    public Opp<T> filter(SerPred<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return Opp.empty();
        }
        return predicate.test(this.value) ? this : Opp.empty();
    }

    public <U> Opp<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opp.empty();
        }
        return Opp.of(mapper.apply(this.value));
    }

    public <U> Opp<U> flatMap(Function<? super T, ? extends Opp<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opp.empty();
        }
        Opp<? extends U> r = mapper.apply(this.value);
        return Objects.requireNonNull(r);
    }

    public <U> Opp<U> flattedMap(Function<? super T, Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opp.empty();
        }
        return Opp.of(mapper.apply(this.value).orElse(null));
    }

    public Opp<T> peek(Consumer<T> action) throws NullPointerException {
        Objects.requireNonNull(action);
        if (this.isEmpty()) {
            return Opp.empty();
        }
        action.accept(this.value);
        return this;
    }

    @SafeVarargs
    public final Opp<T> peeks(Consumer<T> ... actions) throws NullPointerException {
        return this.peek(Stream.of(actions).reduce(Consumer::andThen).orElseGet(() -> o -> {}));
    }

    public <U> Opp<T> typeOfPeek(SerCons<U> action) {
        return Opp.ofTry(() -> {
            LambdaExecutable resolve = LambdaHelper.resolve(action);
            Type[] types = resolve.getParameterTypes();
            return types[types.length - 1];
        }).flatMap(type -> this.typeOfPeek((Type)type, action));
    }

    public <U, R> Opp<R> typeOfMap(SerFunc<U, R> mapper) {
        return Opp.ofTry(() -> {
            Type[] types = LambdaHelper.resolve(mapper).getParameterTypes();
            return types[types.length - 1];
        }).flatMap(type -> this.typeOfMap((Type)type, mapper));
    }

    public <U> Opp<T> typeOfFilter(SerPred<U> predicate) {
        return Opp.ofTry(() -> {
            Type[] types = LambdaHelper.resolve(predicate).getParameterTypes();
            return types[types.length - 1];
        }).flatMap(type -> this.typeOfFilter((Type)type, predicate));
    }

    public <U> Opp<T> typeOfPeek(Type type, SerCons<U> action) {
        return Opp.of(type).flatMap(t -> this.filter(obj -> ReflectHelper.isInstance(obj, t)).peek(v -> action.accept(v)));
    }

    public <U, R> Opp<R> typeOfMap(Type type, SerFunc<U, R> mapper) {
        return Opp.of(type).flatMap(t -> this.filter(obj -> ReflectHelper.isInstance(obj, t)).map(v -> mapper.apply(v)));
    }

    public <U> Opp<T> typeOfFilter(Type type, SerPred<U> predicate) {
        return Opp.of(type).flatMap(t -> this.filter(obj -> ReflectHelper.isInstance(obj, t)).filter(v -> predicate.test(v)));
    }

    public Opp<T> or(Supplier<? extends Opp<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Opp<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Steam<T> steam() {
        if (this.isEmpty()) {
            return Steam.empty();
        }
        return Steam.of(Stream.of(this.value));
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public <R extends Runnable> T orElseRun(R action) {
        if (this.isPresent()) {
            return this.value;
        }
        action.run();
        return null;
    }

    public T failOrElse(T other) {
        return this.isFail() ? other : this.value;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.value : supplier.get();
    }

    public T orElseThrow() {
        return this.orElseThrow(() -> Objects.nonNull(this.throwable) ? new RuntimeException(this.throwable) : new NoSuchElementException("No value present"));
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opp)) {
            return false;
        }
        Opp other = (Opp)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.isPresent() ? this.value.toString() : null;
    }

    public <R> Opp<T> filterEqual(R value) {
        return this.filter(SerPred.isEqual(new Object[]{value}));
    }

    public <R> boolean isEqual(R value) {
        return this.filterEqual(value).isPresent();
    }

    public boolean is(SerPred<T> predicate) {
        return this.filter(predicate).isPresent();
    }

    public <R> Opp<R> zip(Opp<R> other, BiFunction<T, R, R> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty() || other.isEmpty()) {
            return Opp.empty();
        }
        return Opp.of(mapper.apply(this.value, other.value));
    }

    public Opp<T> zipOrSelf(Opp<T> other, BinaryOperator<T> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opp.empty();
        }
        if (other.isEmpty()) {
            return this;
        }
        return Opp.of(mapper.apply(this.value, other.value));
    }
}

