/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.optional;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.dromara.stream.core.lambda.function.SerCons;
import org.dromara.stream.core.lambda.function.SerFunc;
import org.dromara.stream.core.lambda.function.SerRunn;
import org.dromara.stream.core.lambda.function.SerSupp;
import org.dromara.stream.core.stream.Steam;

public class Sf<T> {
    private static final Sf<?> EMPTY = new Sf<Object>(null);
    private final T value;
    private final boolean notActive;

    public Sf(T value) {
        this.value = value;
        this.notActive = Objects.isNull(this.value);
    }

    public Sf(T value, boolean notActive) {
        this.value = value;
        this.notActive = notActive;
    }

    public static <T> Sf<T> of(T value) {
        return new Sf<T>(value, false);
    }

    static <T> Sf<T> of(T value, boolean notActive) {
        return new Sf<T>(value, notActive);
    }

    public static <E, T extends Collection<E>> Sf<T> ofColl(T value) {
        return Sf.of(value).mayTakeIf(c -> !c.isEmpty());
    }

    public static <E, T extends Collection<E>> Sf<T> mayColl(T value) {
        return Sf.ofColl(value).mayTakeIf(c -> Steam.of(c).anyMatch(Objects::nonNull));
    }

    public static <T extends CharSequence> Sf<T> ofStr(T value) {
        return Sf.of(value).mayTakeIf(c -> !c.toString().isEmpty());
    }

    public static <T extends CharSequence> Sf<T> mayStr(T value) {
        return Sf.ofStr(value).mayTakeIf(c -> Steam.split(c.toString(), "").anyMatch(e -> !" ".equals(e)));
    }

    public static <R> Sf<R> empty() {
        Sf<?> empty = EMPTY;
        return empty;
    }

    public boolean isEmpty() {
        return Objects.isNull(this.value);
    }

    public boolean isPresent() {
        return Objects.nonNull(this.value);
    }

    public T get() {
        return this.value;
    }

    public <R> Sf<R> let(SerFunc<T, R> function) {
        if (this.notActive) {
            return Sf.empty();
        }
        return Sf.of(function.apply(this.value), false);
    }

    public <R> Sf<R> mayLet(SerFunc<T, R> function) {
        if (this.isEmpty()) {
            return Sf.empty();
        }
        return this.let(function);
    }

    public Sf<T> also(SerCons<T> consumer) {
        if (this.notActive) {
            return Sf.empty();
        }
        consumer.accept(this.value);
        return this;
    }

    public Sf<T> mayAlso(SerCons<T> consumer) {
        if (this.isEmpty()) {
            return Sf.empty();
        }
        return this.also(consumer);
    }

    public Sf<T> takeIf(SerFunc<T, Boolean> function) {
        if (this.notActive || !Boolean.TRUE.equals(function.apply(this.value))) {
            return Sf.empty();
        }
        return this;
    }

    public Sf<T> mayTakeIf(SerFunc<T, Boolean> function) {
        if (this.isEmpty()) {
            return Sf.empty();
        }
        return this.takeIf(function);
    }

    public Sf<T> takeUnless(SerFunc<T, Boolean> function) {
        return this.takeIf(v -> Boolean.FALSE.equals(function.apply(v)));
    }

    public Sf<T> mayTakeUnless(SerFunc<T, Boolean> function) {
        if (this.isEmpty()) {
            return Sf.empty();
        }
        return this.takeUnless(function);
    }

    public boolean is(SerFunc<T, Boolean> function) {
        return this.isPresent() && Boolean.TRUE.equals(function.apply(this.value));
    }

    public <X extends Throwable> Sf<T> require(SerSupp<X> supplier) throws X {
        if (this.isPresent()) {
            return this;
        }
        throw (Throwable)supplier.get();
    }

    public Sf<T> require() {
        return this.require(NoSuchElementException::new);
    }

    public Sf<T> or(SerSupp<Sf<T>> supplier) {
        if (this.isPresent()) {
            return this;
        }
        return supplier.get();
    }

    public T orElse(T other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public T orGet(SerSupp<T> supplier) {
        if (this.isPresent()) {
            return this.value;
        }
        return supplier.get();
    }

    public T orRun(SerRunn mapper) {
        if (this.isEmpty()) {
            mapper.run();
        }
        return this.value;
    }

    public <X extends Throwable> T orThrow(SerSupp<X> supplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)supplier.get();
    }

    public T orThrow() {
        return this.orThrow(NoSuchElementException::new);
    }
}

