/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.dromara.stream.core.collection.Maps;
import org.dromara.stream.core.lambda.function.SerPred;
import org.dromara.stream.core.optional.Opp;
import org.dromara.stream.core.stream.Steam;
import org.dromara.stream.core.stream.collector.Collective;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ReflectHelper {
    private static final Logger logger = Logger.getAnonymousLogger();
    public static final String LEFT_MIDDLE_BRACKET = "[";
    public static final String SEMICOLON = ";";
    public static final String L = "L";
    public static final String V = "V";
    private static final WeakHashMap<Class<?>, List<Field>> CLASS_FIELDS_CACHE = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Method>> CLASS_METHODS_CACHE = new WeakHashMap();

    private ReflectHelper() {
    }

    public static <$ACCESSIBLE_OBJECT extends AccessibleObject> $ACCESSIBLE_OBJECT accessible($ACCESSIBLE_OBJECT accessibleObject) {
        if (accessibleObject.isAccessible()) {
            return accessibleObject;
        }
        return ($ACCESSIBLE_OBJECT)AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return accessibleObject;
        });
    }

    public static String getDescriptor(Executable executable) {
        Class<?>[] parameters;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> parameter : parameters = executable.getParameterTypes()) {
            ReflectHelper.appendDescriptor(parameter, stringBuilder);
        }
        if (executable instanceof Method) {
            Method method = (Method)executable;
            stringBuilder.append(')');
            ReflectHelper.appendDescriptor(method.getReturnType(), stringBuilder);
            return stringBuilder.toString();
        }
        if (executable instanceof Constructor) {
            return stringBuilder.append(")V").toString();
        }
        throw new IllegalArgumentException("Unknown Executable: " + executable);
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append('[');
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            int descriptor;
            if (currentClass == Boolean.TYPE) {
                descriptor = 90;
            } else if (currentClass == Byte.TYPE) {
                descriptor = 66;
            } else if (currentClass == Short.TYPE) {
                descriptor = 83;
            } else if (currentClass == Character.TYPE) {
                descriptor = 67;
            } else if (currentClass == Integer.TYPE) {
                descriptor = 73;
            } else if (currentClass == Long.TYPE) {
                descriptor = 74;
            } else if (currentClass == Float.TYPE) {
                descriptor = 70;
            } else if (currentClass == Double.TYPE) {
                descriptor = 68;
            } else if (currentClass == Void.TYPE) {
                descriptor = 86;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)descriptor);
        } else {
            stringBuilder.append('L').append(ReflectHelper.getInternalName(currentClass)).append(';');
        }
    }

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        ReflectHelper.appendDescriptor(clazz, stringBuilder);
        return stringBuilder.toString();
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        if (Objects.isNull(obj) || Objects.isNull(fieldName)) {
            throw new IllegalArgumentException("obj or fieldName is null");
        }
        try {
            return (T)ReflectHelper.getField(obj.getClass(), fieldName).get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        return Steam.of(ReflectHelper.getFields(clazz)).anyMatch(f -> fieldName.equals(f.getName()));
    }

    public static List<Field> getFields(Class<?> clazz) {
        return CLASS_FIELDS_CACHE.computeIfAbsent(clazz, k -> {
            Steam.Builder<Field> fieldsBuilder = Steam.builder();
            for (Class currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
                for (Field field : currentClass.getDeclaredFields()) {
                    fieldsBuilder.add(ReflectHelper.accessible(field));
                }
            }
            return fieldsBuilder.build().toList();
        });
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ((Steam)Steam.of(ReflectHelper.getFields(clazz)).filter(field -> field.getName().equals(fieldName))).findFirst().map(ReflectHelper::accessible).orElseThrow(() -> new IllegalArgumentException("No such field: " + fieldName));
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ((Steam)Steam.of(ReflectHelper.getMethods(clazz)).filter(SerPred.multiAnd(method -> method.getName().equals(methodName), method -> Arrays.equals(method.getParameterTypes(), parameterTypes)))).findFirst().map(ReflectHelper::accessible).orElseThrow(() -> new IllegalArgumentException(String.format("No such method: %s args: %s", methodName, Steam.of(parameterTypes).map(Type::getTypeName).join(","))));
    }

    public static List<Method> getMethods(Class<?> clazz) {
        return CLASS_METHODS_CACHE.computeIfAbsent(clazz, k -> Steam.iterate(clazz, Objects::nonNull, Class::getSuperclass).flat(clz -> Steam.of(clz.getDeclaredMethods())).toList());
    }

    public static Type[] getGenericTypes(Type paramType) {
        Type type = ReflectHelper.resolveType(paramType);
        if (type instanceof ParameterizedType) {
            ParameterizedType ty = (ParameterizedType)type;
            return ty.getActualTypeArguments();
        }
        return new Type[0];
    }

    public static Map<String, Type> getGenericMap(Type paramType) {
        Type type = ReflectHelper.resolveType(paramType);
        if (type instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl ty = (ParameterizedTypeImpl)type;
            Type rawType = ty.getRawType();
            return (Map)((Steam)Steam.of(((Class)rawType).getTypeParameters()).map(Type::getTypeName)).zip(Steam.of(ty.getActualTypeArguments()), Maps::entry).collect(Collective.entryToMap(LinkedHashMap::new));
        }
        return new HashMap<String, Type>();
    }

    private static Type resolveType(Type paramType) {
        Type type = paramType;
        while (type instanceof Class) {
            Type[] genericInterfaces;
            if (Object.class.equals((Object)type) && (genericInterfaces = ((Class)type).getGenericInterfaces()).length > 0 && Objects.nonNull(genericInterfaces[0])) {
                type = genericInterfaces[0];
            }
            type = ((Class)type).getGenericSuperclass();
        }
        return type;
    }

    public static <T> boolean isInstance(T obj, Type t) {
        if (Objects.isNull(obj)) {
            return false;
        }
        Type[] sourceTypes = ReflectHelper.getGenericTypes(t);
        if (sourceTypes.length > 0) {
            t = sourceTypes[0];
        }
        if (t instanceof ParameterizedType) {
            t = ((ParameterizedType)t).getRawType();
        }
        if (t instanceof Class) {
            Class clazz = (Class)t;
            return clazz.isInstance(obj);
        }
        return false;
    }

    public static boolean typeOf(Object obj, Type eType) {
        if (eType instanceof Class) {
            Class clazz = (Class)eType;
            return clazz.isInstance(obj);
        }
        return false;
    }

    public static <T> void setFieldValue(T bean, String keyProperty, Object fieldValue) {
        if (Objects.isNull(bean) || Objects.isNull(keyProperty)) {
            return;
        }
        try {
            Field field = bean.getClass().getDeclaredField(keyProperty);
            ReflectHelper.accessible(field);
            field.set(bean, fieldValue);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> Constructor<T> getConstructorByDescriptor(Class<?> clazz, String methodDescriptor) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ReflectHelper.getDescriptor(constructor).equals(methodDescriptor)) continue;
            return constructor;
        }
        throw new IllegalStateException(String.format("No constructor found with class %s and descriptor %s", clazz, methodDescriptor));
    }

    public static Method getMethodByDescriptor(String methodName, Class<?> clazz, String methodDescriptor) {
        for (Method method : ReflectHelper.getMethods(clazz)) {
            if (!method.getName().equals(methodName) || !ReflectHelper.getDescriptor(method).equals(methodDescriptor)) continue;
            return method;
        }
        throw new IllegalStateException(String.format("No method found with class %s and descriptor %s", clazz, methodDescriptor));
    }

    public static Type[] getArgsFromDescriptor(String methodDescriptor) {
        int index = methodDescriptor.indexOf(";)");
        if (index == -1) {
            return new Type[0];
        }
        String className = methodDescriptor.substring(1, index + 1);
        String[] instantiatedTypeNames = className.split(SEMICOLON);
        Type[] types = new Type[instantiatedTypeNames.length];
        for (int i = 0; i < instantiatedTypeNames.length; ++i) {
            types[i] = ReflectHelper.forClassName(instantiatedTypeNames[i]);
        }
        return types;
    }

    public static Type getReturnTypeFromDescriptor(String methodDescriptor) {
        int index = methodDescriptor.indexOf(";)");
        if (index == -1) {
            return null;
        }
        String className = methodDescriptor.substring(index + 2);
        if (V.equals(className)) {
            return Void.TYPE;
        }
        return ReflectHelper.forClassName(className);
    }

    public static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className.replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> forClassName(String className) {
        try {
            boolean isArray = className.startsWith(LEFT_MIDDLE_BRACKET);
            if (isArray && !className.endsWith(SEMICOLON)) {
                className = className + SEMICOLON;
            }
            if (!isArray && className.startsWith(L)) {
                className = className.substring(1);
            }
            if (!isArray && className.endsWith(SEMICOLON)) {
                className = className.substring(0, className.length() - 1);
            }
            return Class.forName(className.replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <R> R invoke(Object obj, Method method, Object ... args) {
        try {
            return (R)ReflectHelper.accessible(method).invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void explain(Object obj) {
        logger.info(() -> "obj: " + obj + " class: " + obj.getClass());
        logger.info(() -> "fields: ");
        ((Steam)Steam.of(ReflectHelper.getFields(obj.getClass())).map(Field::getName)).forEach(fieldName -> logger.info(() -> "field " + fieldName + ": " + ReflectHelper.getFieldValue(obj, fieldName)));
        logger.info(() -> "no arg methods: ");
        ((Steam)Steam.of(ReflectHelper.getMethods(obj.getClass())).map(Method::getName)).forEach(methodName -> logger.info(() -> "method " + methodName + ": " + Opp.ofTry(() -> ReflectHelper.getMethod(obj.getClass(), methodName, new Class[0]).invoke(obj, new Object[0]))));
    }
}

