/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.stream.collector;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.dromara.stream.core.lambda.function.SerBiOp;
import org.dromara.stream.core.lambda.function.SerFunc;
import org.dromara.stream.core.lambda.function.SerPred;
import org.dromara.stream.core.lambda.function.SerUnOp;
import org.dromara.stream.core.optional.Opp;
import org.dromara.stream.core.stream.Steam;

public class Collective {
    static final Set<Collector.Characteristics> CH_CONCURRENT_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_CONCURRENT_NOID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED));
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();
    private static final String NON_NULL_MSG = "element cannot be mapped to a null key";

    private Collective() {
    }

    public static <T> Collector<T, ?, T[]> toArray(IntFunction<T[]> arrayFactor) {
        return Collective.collectingAndThen(Collective.toList(), list -> list.toArray((Object[])arrayFactor.apply(list.size())));
    }

    public static <T, C extends Collection<T>> Collector<T, ?, C> toCollection(Supplier<C> collectionFactory) {
        return new CollectorImpl(collectionFactory, Collection::add, (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, List<T>> toList() {
        return new CollectorImpl(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        return new CollectorImpl(HashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_UNORDERED_ID);
    }

    public static Collector<CharSequence, ?, String> joining() {
        return new CollectorImpl<CharSequence, StringBuilder, String>(StringBuilder::new, StringBuilder::append, (r1, r2) -> {
            r1.append((CharSequence)r2);
            return r1;
        }, StringBuilder::toString, CH_NOID);
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return Collective.joining(delimiter, "", "");
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new CollectorImpl<CharSequence, StringJoiner, String>(() -> new StringJoiner(delimiter, prefix, suffix), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, CH_NOID);
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    public static <T, U, A, R> Collector<T, ?, R> mapping(Function<? super T, ? extends U> mapper, Collector<? super U, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (r, t) -> downstreamAccumulator.accept((Object)r, (Object)Opp.of(t).map(mapper).get()), downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, U, A, R> Collector<T, ?, R> flatMapping(Function<? super T, Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (r, t) -> Opp.of(t).map(mapper).ifPresent(s -> ((Stream)s.sequential()).forEach(v -> downstreamAccumulator.accept(r, v))), downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, A, R> Collector<T, ?, R> filtering(SerPred<? super T> predicate, Collector<? super T, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (r, t) -> Opp.of(t).filter(predicate).ifPresent(e -> downstreamAccumulator.accept(r, e)), downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, U, A, R> Collector<T, ?, R> flatMappingIter(Function<? super T, Iterable<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        return Collective.flatMapping(t -> Opp.of(t).map(mapper).map(Steam::of).get(), downstream);
    }

    public static <T, A, R, RR> Collector<T, A, RR> collectingAndThen(Collector<T, A, R> downstream, Function<R, RR> finisher) {
        Set<Collector.Characteristics> characteristics = downstream.characteristics();
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            if (characteristics.size() != 1) {
                characteristics = EnumSet.copyOf(characteristics);
                characteristics.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                characteristics = Collections.unmodifiableSet(characteristics);
            } else {
                characteristics = CH_NOID;
            }
        }
        return new CollectorImpl<T, A, RR>(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(finisher), characteristics);
    }

    public static <T> Collector<T, ?, Long> counting() {
        return Collective.reducing(0L, e -> 1L, Long::sum);
    }

    public static <T> Collector<T, ?, Optional<T>> minBy(Comparator<? super T> comparator) {
        return Collective.reducing(BinaryOperator.minBy(comparator));
    }

    public static <T> Collector<T, ?, Optional<T>> maxBy(Comparator<? super T> comparator) {
        return Collective.reducing(BinaryOperator.maxBy(comparator));
    }

    public static <T> Collector<T, ?, Integer> summingInt(ToIntFunction<? super T> mapper) {
        return new CollectorImpl<Object, int[], Integer>(() -> new int[1], (a, t) -> {
            a[0] = a[0] + mapper.applyAsInt(t);
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> Collector<T, ?, Long> summingLong(ToLongFunction<? super T> mapper) {
        return new CollectorImpl<Object, long[], Long>(() -> new long[1], (a, t) -> {
            a[0] = a[0] + mapper.applyAsLong(t);
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> summingDouble(ToDoubleFunction<? super T> mapper) {
        return new CollectorImpl<Object, double[], Double>(() -> new double[3], (a, t) -> {
            Collective.sumWithCompensation(a, mapper.applyAsDouble(t));
            a[2] = a[2] + mapper.applyAsDouble(t);
        }, (a, b) -> {
            Collective.sumWithCompensation(a, b[0]);
            a[2] = a[2] + b[2];
            return Collective.sumWithCompensation(a, b[1]);
        }, Collective::computeFinalSum, CH_NOID);
    }

    static double[] sumWithCompensation(double[] intermediateSum, double value) {
        double tmp = value - intermediateSum[1];
        double sum = intermediateSum[0];
        double velvel = sum + tmp;
        intermediateSum[1] = velvel - sum - tmp;
        intermediateSum[0] = velvel;
        return intermediateSum;
    }

    static double computeFinalSum(double[] summands) {
        double tmp = summands[0] + summands[1];
        double simpleSum = summands[summands.length - 1];
        if (Double.isNaN(tmp) && Double.isInfinite(simpleSum)) {
            return simpleSum;
        }
        return tmp;
    }

    public static <T> Collector<T, ?, Double> averagingInt(ToIntFunction<? super T> mapper) {
        return new CollectorImpl<Object, long[], Double>(() -> new long[2], (a, t) -> {
            a[0] = a[0] + (long)mapper.applyAsInt(t);
            a[1] = a[1] + 1L;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }, a -> a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingLong(ToLongFunction<? super T> mapper) {
        return new CollectorImpl<Object, long[], Double>(() -> new long[2], (a, t) -> {
            a[0] = a[0] + mapper.applyAsLong(t);
            a[1] = a[1] + 1L;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }, a -> a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingDouble(ToDoubleFunction<? super T> mapper) {
        return new CollectorImpl<Object, double[], Double>(() -> new double[4], (a, t) -> {
            Collective.sumWithCompensation(a, mapper.applyAsDouble(t));
            a[2] = a[2] + 1.0;
            a[3] = a[3] + mapper.applyAsDouble(t);
        }, (a, b) -> {
            Collective.sumWithCompensation(a, b[0]);
            Collective.sumWithCompensation(a, b[1]);
            a[2] = a[2] + b[2];
            a[3] = a[3] + b[3];
            return a;
        }, a -> a[2] == 0.0 ? 0.0 : Collective.computeFinalSum(a) / a[2], CH_NOID);
    }

    public static <T> Collector<T, ?, T> reducing(T identity, BinaryOperator<T> op) {
        return new CollectorImpl<Object, Object[], Object>(Collective.boxSupplier(identity), (a, t) -> {
            a[0] = op.apply(a[0], t);
        }, (a, b) -> {
            a[0] = op.apply(a[0], b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    private static <T> Supplier<T[]> boxSupplier(T identity) {
        return () -> new Object[]{identity};
    }

    public static <T> Collector<T, ?, Optional<T>> reducing(BinaryOperator<T> op) {
        class OptionalBox
        implements Consumer<T> {
            T value = null;
            boolean present = false;
            final /* synthetic */ BinaryOperator val$op;

            OptionalBox(BinaryOperator binaryOperator) {
                this.val$op = binaryOperator;
            }

            @Override
            public void accept(T t) {
                if (this.present) {
                    this.value = this.val$op.apply(this.value, t);
                } else {
                    this.value = t;
                    this.present = true;
                }
            }
        }
        return new CollectorImpl<Object, OptionalBox, Optional>(() -> new OptionalBox(op), OptionalBox::accept, (a, b) -> {
            if (b.present) {
                a.accept(b.value);
            }
            return a;
        }, a -> Optional.ofNullable(a.value), CH_NOID);
    }

    public static <T, U> Collector<T, ?, U> reducing(U identity, Function<? super T, ? extends U> mapper, BinaryOperator<U> op) {
        return new CollectorImpl<Object, Object[], Object>(Collective.boxSupplier(identity), (a, t) -> {
            a[0] = op.apply(a[0], mapper.apply(t));
        }, (a, b) -> {
            a[0] = op.apply(a[0], b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> classifier) {
        return Collective.groupingBy(classifier, Collective.toList());
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Collective.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Supplier<? super M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = Opp.of(t).map(classifier).orElse(null);
            Object container = m.computeIfAbsent(key, arg_0 -> Collective.lambda$null$48((Supplier)downstreamSupplier, arg_0));
            Opp.of(t).ifPresent(o -> downstreamAccumulator.accept(container, o));
        };
        BinaryOperator<M> merger = Collective.mapMerger(downstream.combiner());
        Supplier<? super M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(mangledFactory, accumulator, merger, CH_ID);
        }
        SerUnOp downstreamFinisher = SerUnOp.casting(downstream.finisher());
        Function<Map, Map> finisher = intermediate -> {
            intermediate.replaceAll((k, v) -> downstreamFinisher.apply(v));
            return (Map)SerFunc.cast().apply((Map)intermediate);
        };
        return new CollectorImpl<Object, Map, Map>(mangledFactory, accumulator, merger, finisher, CH_NOID);
    }

    public static <T, K> Collector<T, ?, ConcurrentMap<K, List<T>>> groupingByConcurrent(Function<? super T, ? extends K> classifier) {
        return Collective.groupingByConcurrent(classifier, ConcurrentHashMap::new, Collective.toList());
    }

    public static <T, K, A, D> Collector<T, ?, ConcurrentMap<K, D>> groupingByConcurrent(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Collective.groupingByConcurrent(classifier, ConcurrentHashMap::new, downstream);
    }

    public static <T, K, A, D, M extends ConcurrentMap<K, D>> Collector<T, ?, M> groupingByConcurrent(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BinaryOperator<M> merger = Collective.mapMerger(downstream.combiner());
        Supplier mangledFactory = (Supplier)SerFunc.cast().apply(mapFactory);
        BiConsumer<ConcurrentMap, Object> accumulator = downstream.characteristics().contains((Object)Collector.Characteristics.CONCURRENT) ? (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t), NON_NULL_MSG);
            Object resultContainer = m.computeIfAbsent(key, arg_0 -> Collective.lambda$null$53((Supplier)downstreamSupplier, arg_0));
            downstreamAccumulator.accept(resultContainer, t);
        } : (m, t) -> {
            Object resultContainer;
            Object key = Objects.requireNonNull(classifier.apply(t), NON_NULL_MSG);
            Object object = resultContainer = m.computeIfAbsent(key, arg_0 -> Collective.lambda$null$55((Supplier)downstreamSupplier, arg_0));
            synchronized (object) {
                downstreamAccumulator.accept(resultContainer, t);
            }
        };
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(mangledFactory, accumulator, merger, CH_CONCURRENT_ID);
        }
        SerUnOp downstreamFinisher = SerUnOp.casting(downstream.finisher());
        Function<ConcurrentMap, ConcurrentMap> finisher = intermediate -> {
            intermediate.replaceAll((k, v) -> downstreamFinisher.apply(v));
            return (ConcurrentMap)SerFunc.cast().apply((ConcurrentMap)intermediate);
        };
        return new CollectorImpl<Object, ConcurrentMap, ConcurrentMap>(mangledFactory, accumulator, merger, finisher, CH_CONCURRENT_NOID);
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(Predicate<? super T> predicate) {
        return Collective.partitioningBy(predicate, Collective.toList());
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(Predicate<? super T> predicate, Collector<? super T, A, D> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Partition, Object> accumulator = (result, t) -> downstreamAccumulator.accept((Object)(predicate.test(t) ? result.forTrue : result.forFalse), (Object)t);
        BinaryOperator op = downstream.combiner();
        BinaryOperator merger = (left, right) -> new Partition(op.apply(left.forTrue, right.forTrue), op.apply(left.forFalse, right.forFalse));
        Supplier<Partition> supplier = () -> new Partition(downstream.supplier().get(), downstream.supplier().get());
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier, accumulator, merger, CH_ID);
        }
        Function<Partition, Map> finisher = par -> new Partition(downstream.finisher().apply(par.forTrue), downstream.finisher().apply(par.forFalse));
        return new CollectorImpl<Object, Partition, Map>(supplier, accumulator, merger, finisher, CH_NOID);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collective.toMap(keyMapper, valueMapper, SerBiOp.justAfter(), HashMap::new);
    }

    public static <T, K> Collector<T, ?, Map<K, T>> toMap(Function<? super T, ? extends K> keyMapper) {
        return Collective.toMap(keyMapper, Function.identity(), SerBiOp.justAfter(), HashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collective.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> {
            Opp keyOpp = Opp.of(element).map(keyMapper);
            Object value = Opp.of(element).map(valueMapper).map(newValue -> keyOpp.map(map::get).map(oldValue -> mergeFunction.apply(oldValue, newValue)).orElse(newValue)).get();
            map.put(keyOpp.get(), value);
        };
        return new CollectorImpl(mapSupplier, accumulator, Collective.mapMerger(mergeFunction), CH_ID);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collective.toConcurrentMap(keyMapper, valueMapper, SerBiOp.justAfter(), ConcurrentHashMap::new);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collective.toConcurrentMap(keyMapper, valueMapper, mergeFunction, ConcurrentHashMap::new);
    }

    public static <T, K, U, M extends ConcurrentMap<K, U>> Collector<T, ?, M> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<ConcurrentMap, Object> accumulator = (map, element) -> map.merge(keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
        return new CollectorImpl(mapSupplier, accumulator, Collective.mapMerger(mergeFunction), CH_CONCURRENT_ID);
    }

    public static <T> Collector<T, ?, IntSummaryStatistics> summarizingInt(ToIntFunction<? super T> mapper) {
        return new CollectorImpl(IntSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsInt(t)), (l, r) -> {
            l.combine((IntSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, LongSummaryStatistics> summarizingLong(ToLongFunction<? super T> mapper) {
        return new CollectorImpl(LongSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsLong(t)), (l, r) -> {
            l.combine((LongSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, DoubleSummaryStatistics> summarizingDouble(ToDoubleFunction<? super T> mapper) {
        return new CollectorImpl(DoubleSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsDouble(t)), (l, r) -> {
            l.combine((DoubleSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entryToMap() {
        return Collective.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> entryToMap(Supplier<M> mapSupplier) {
        return Collective.toMap(Map.Entry::getKey, Map.Entry::getValue, SerBiOp.justAfter(), mapSupplier);
    }

    public static <T> Collector<T, ?, Steam<T>> toSteam() {
        return Collective.transform(ArrayList::new, Steam::of);
    }

    public static <T, R, C extends Collection<T>> Collector<T, C, R> transform(Supplier<C> collFactory, Function<C, R> mapper) {
        Objects.requireNonNull(collFactory);
        Objects.requireNonNull(mapper);
        return new CollectorImpl<Object, Collection, R>(collFactory, Collection::add, (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }, mapper, CH_NOID);
    }

    public static <T, R> Collector<T, List<T>, R> transform(Function<List<T>, R> mapper) {
        return Collective.transform(ArrayList::new, mapper);
    }

    private static /* synthetic */ Object lambda$null$55(Supplier downstreamSupplier, Object k) {
        return downstreamSupplier.get();
    }

    private static /* synthetic */ Object lambda$null$53(Supplier downstreamSupplier, Object k) {
        return downstreamSupplier.get();
    }

    private static /* synthetic */ Object lambda$null$48(Supplier downstreamSupplier, Object k) {
        return downstreamSupplier.get();
    }

    private static final class Partition<T>
    extends AbstractMap<Boolean, T>
    implements Map<Boolean, T> {
        final T forTrue;
        final T forFalse;

        Partition(T forTrue, T forFalse) {
            this.forTrue = forTrue;
            this.forFalse = forFalse;
        }

        @Override
        public Set<Map.Entry<Boolean, T>> entrySet() {
            return new AbstractSet<Map.Entry<Boolean, T>>(){

                @Override
                public Iterator<Map.Entry<Boolean, T>> iterator() {
                    AbstractMap.SimpleImmutableEntry falseEntry = new AbstractMap.SimpleImmutableEntry(false, forFalse);
                    AbstractMap.SimpleImmutableEntry trueEntry = new AbstractMap.SimpleImmutableEntry(true, forTrue);
                    return Arrays.asList(falseEntry, trueEntry).iterator();
                }

                @Override
                public int size() {
                    return 2;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Partition partition = (Partition)o;
            return Objects.equals(this.forTrue, partition.forTrue) && Objects.equals(this.forFalse, partition.forFalse);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.forTrue, this.forFalse);
        }
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, SerFunc.cast(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

