/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Lists {
    private Lists() {
    }

    @SafeVarargs
    public static <T> List<T> of(T ... values) {
        if (Objects.isNull(values) || values.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static <T> List<T> ofColl(Collection<T> values) {
        if (Objects.isNull(values)) {
            return new ArrayList();
        }
        return new ArrayList<T>(values);
    }

    public static <T> T first(List<T> values) {
        if (Lists.isEmpty(values)) {
            return null;
        }
        return values.get(0);
    }

    public static <T> T last(List<T> values) {
        if (Lists.isEmpty(values)) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    public static <T> List<T> ascend(List<T> list) {
        list.sort(Collections.reverseOrder().reversed());
        return list;
    }

    public static <T> List<T> descend(List<T> list) {
        list.sort(Collections.reverseOrder());
        return list;
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T key) {
        return Collections.binarySearch(Lists.ascend(list), key);
    }

    public static boolean isEmpty(Collection<?> list) {
        return Objects.isNull(list) || list.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> list) {
        return Objects.nonNull(list) && !list.isEmpty();
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }
}

