/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.lambda;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import org.dromara.streamquery.stream.core.lambda.LambdaHelper;
import org.dromara.streamquery.stream.core.reflect.ReflectHelper;

public class LambdaExecutable {
    public static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    public static final String NEW_INSTANCE_METHOD_NAME = "newInstance";
    private Executable executable;
    private Type[] instantiatedTypes;
    private Type[] parameterTypes;
    private Type returnType;
    private String name;
    private Class<?> clazz;
    private SerializedLambda lambda;
    private Proxy proxy;

    public LambdaExecutable() {
    }

    public LambdaExecutable(SerializedLambda lambda) {
        MethodType methodType = MethodType.fromMethodDescriptorString(lambda.getInstantiatedMethodType(), Thread.currentThread().getContextClassLoader());
        Type[] instantiatedTypes = (Class[])ReflectHelper.getFieldValue(methodType, "ptypes");
        Class returnType = (Class)ReflectHelper.getFieldValue(methodType, "rtype");
        try {
            Class<?> implClass = ReflectHelper.loadClass(lambda.getImplClass());
            if (CONSTRUCTOR_METHOD_NAME.equals(lambda.getImplMethodName())) {
                this.initConstructor(ReflectHelper.getConstructorByDescriptor(implClass, lambda.getImplMethodSignature()));
            } else {
                this.initMethod(ReflectHelper.getMethodByDescriptor(lambda.getImplMethodName(), implClass, lambda.getImplMethodSignature()));
            }
        }
        catch (IllegalStateException e) {
            this.setParameterTypes(ReflectHelper.getArgsFromDescriptor(lambda.getImplMethodSignature()));
            this.setName(lambda.getImplMethodName());
        }
        this.setInstantiatedTypes(instantiatedTypes);
        this.setReturnType(returnType);
        this.setLambda(lambda);
    }

    public LambdaExecutable(Executable executable) {
        if (executable instanceof Constructor) {
            this.initConstructor((Constructor)executable);
        } else {
            this.initMethod((Method)executable);
        }
    }

    private void initConstructor(Constructor<?> constructor) {
        this.executable = constructor;
        this.parameterTypes = constructor.getGenericParameterTypes();
        this.returnType = constructor.getDeclaringClass();
        this.name = constructor.getName();
        this.clazz = constructor.getDeclaringClass();
    }

    private void initMethod(Method method) {
        this.executable = method;
        this.parameterTypes = method.getGenericParameterTypes();
        this.returnType = method.getGenericReturnType();
        this.name = method.getName();
        this.clazz = method.getDeclaringClass();
    }

    public static LambdaExecutable initProxy(Proxy proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        MethodHandle methodHandle = (MethodHandle)ReflectHelper.getFieldValue(handler, "val$target");
        Executable executable = MethodHandles.reflectAs(Executable.class, methodHandle);
        Class lambdaClazz = (Class)ReflectHelper.getFieldValue(handler, "val$intfc");
        Serializable lambda = (Serializable)LambdaHelper.revert(lambdaClazz, executable);
        try {
            LambdaExecutable resolve = LambdaHelper.resolve(lambda);
            return resolve;
        }
        catch (IllegalArgumentException e) {
            LambdaExecutable lambdaExecutable = LambdaExecutable.notDirectMethodHandle(methodHandle);
            lambdaExecutable.setProxy(proxy);
            return lambdaExecutable;
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public Type[] getInstantiatedTypes() {
        return this.instantiatedTypes;
    }

    public void setInstantiatedTypes(Type[] instantiatedTypes) {
        this.instantiatedTypes = instantiatedTypes;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Type[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public SerializedLambda getLambda() {
        return this.lambda;
    }

    public void setLambda(SerializedLambda lambda) {
        this.lambda = lambda;
    }

    private static LambdaExecutable notDirectMethodHandle(MethodHandle methodHandle) {
        List internalValues = (List)ReflectHelper.invoke(methodHandle, ReflectHelper.getMethod(methodHandle.getClass(), "internalValues", new Class[0]), new Object[0]);
        MethodHandle internalMethodHandle = (MethodHandle)internalValues.get(0);
        Executable internalExecutable = MethodHandles.reflectAs(Executable.class, internalMethodHandle);
        LambdaExecutable lambdaExecutable = new LambdaExecutable(internalExecutable);
        lambdaExecutable.setInstantiatedTypes(ReflectHelper.getArgsFromDescriptor(methodHandle.type().toMethodDescriptorString()));
        if (ReflectHelper.getMethod(Array.class, NEW_INSTANCE_METHOD_NAME, Class.class, Integer.TYPE).equals(internalExecutable)) {
            lambdaExecutable.setParameterTypes(new Type[]{Integer.TYPE});
            lambdaExecutable.setInstantiatedTypes(new Type[]{Integer.class});
            lambdaExecutable.setReturnType(Array.newInstance((Class)internalValues.get(1), 0).getClass());
            StackTraceElement stackTraceElement = new RuntimeException().getStackTrace()[7];
            lambdaExecutable.setClazz(ReflectHelper.forClassName(stackTraceElement.getClassName()));
            lambdaExecutable.setName("lambda$" + stackTraceElement.getMethodName() + "$" + Integer.toHexString(methodHandle.hashCode()) + "$1");
        }
        return lambdaExecutable;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

