/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.lambda.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.dromara.streamquery.stream.core.lambda.LambdaInvokeException;

@FunctionalInterface
public interface SerPred<T>
extends Predicate<T>,
Serializable {
    public Boolean testing(T var1) throws Throwable;

    @Override
    default public boolean test(T t) {
        try {
            return Boolean.TRUE.equals(this.testing(t));
        }
        catch (Throwable e) {
            throw new LambdaInvokeException(e);
        }
    }

    @SafeVarargs
    public static <T> SerPred<T> multiAnd(SerPred<T> ... predicates) {
        return Stream.of(predicates).reduce(SerPred::and).orElseGet(() -> o -> true);
    }

    @SafeVarargs
    public static <T> SerPred<T> multiOr(SerPred<T> ... predicates) {
        return Stream.of(predicates).reduce(SerPred::or).orElseGet(() -> o -> false);
    }

    public static <T> SerPred<T> isEqual(Object ... targetRef) {
        return null == targetRef ? Objects::isNull : object -> Stream.of(targetRef).allMatch(target -> target.equals(object));
    }

    @Override
    default public SerPred<T> and(SerPred<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    @Override
    default public SerPred<T> negate() {
        return t -> !this.test(t);
    }

    @Override
    default public SerPred<T> or(SerPred<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }
}

