/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dromara.streamquery.stream.core.collection.Maps;
import org.dromara.streamquery.stream.core.lambda.function.SerBiCons;
import org.dromara.streamquery.stream.core.optional.Opp;
import org.dromara.streamquery.stream.core.stream.AbstractStreamWrapper;
import org.dromara.streamquery.stream.core.stream.CollectableStream;

public class Steam<T>
extends AbstractStreamWrapper<T, Steam<T>>
implements Stream<T>,
Iterable<T>,
CollectableStream<T> {
    protected static final int NOT_FOUND_INDEX = -1;

    Steam(Stream<T> stream) {
        super(stream);
    }

    public static <T> Builder<T> builder() {
        return new Builder<T>(){
            private final Stream.Builder<T> builder = Stream.builder();

            @Override
            public void accept(T t) {
                this.builder.accept(t);
            }

            @Override
            public Steam<T> build() {
                return new Steam(this.builder.build());
            }
        };
    }

    public static <T> Steam<T> empty() {
        return new Steam(Stream.empty());
    }

    public static <T> Steam<T> of(T t) {
        return new Steam<T>(Stream.of(t));
    }

    @SafeVarargs
    public static <T> Steam<T> of(T ... values) {
        return values == null || values.length == 0 ? Steam.empty() : new Steam<T>(Stream.of(values));
    }

    public static <T> Steam<T> iterate(T seed, UnaryOperator<T> f) {
        return new Steam<T>(Stream.iterate(seed, f));
    }

    public static <T> Steam<T> iterate(final T seed, final Predicate<? super T> hasNext, final UnaryOperator<T> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            T prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = next.apply(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!hasNext.test(t)) {
                    this.prev = null;
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Object t = this.started ? next.apply(this.prev) : seed;
                this.prev = null;
                while (hasNext.test(t)) {
                    action.accept(t);
                    t = next.apply(t);
                }
            }
        };
        return new Steam(StreamSupport.stream(spliterator, false));
    }

    public static <T> Steam<T> generate(Supplier<T> s) {
        return new Steam<T>(Stream.generate(s));
    }

    public static <T> Steam<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        return new Steam<T>(Stream.concat(a, b));
    }

    public static <T> Steam<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return new Steam<T>(Stream.concat(Steam.of(a), Steam.of(b)));
    }

    public static <T> Steam<T> of(Iterable<T> iterable) {
        return Steam.of(iterable, false);
    }

    public static <T> Steam<T> of(Iterable<T> iterable, boolean parallel) {
        return Opp.of(iterable).map(Iterable::spliterator).map((? super T spliterator) -> StreamSupport.stream(spliterator, parallel)).map(Steam::new).orElseGet(Steam::empty);
    }

    public static <T> Steam<T> of(Stream<T> stream) {
        return new Steam<T>(Objects.requireNonNull(stream));
    }

    public static <T extends CharSequence> Steam<String> split(T str, String regex) {
        return Opp.of(str).map(CharSequence::toString).map((? super T s) -> s.split(regex)).map(Steam::of).orElseGet(Steam::empty);
    }

    public <R> Steam<T> filter(Function<? super T, ? extends R> mapper, R value) {
        Objects.requireNonNull(mapper);
        return (Steam)this.filter(e -> Objects.equals(Opp.of(e).map(mapper).get(), value));
    }

    public Steam<T> filterIdx(BiPredicate<? super T, Integer> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isParallel()) {
            return ((Steam)Steam.of(this.toIdxMap().entrySet()).parallel(this.isParallel()).filter(e -> predicate.test((Object)e.getValue(), (Integer)e.getKey()))).map(Map.Entry::getValue);
        }
        AtomicInteger index = new AtomicInteger(-1);
        return (Steam)this.filter(e -> predicate.test(e, index.incrementAndGet()));
    }

    public Steam<T> nonNull() {
        return new Steam<Object>(this.stream.filter(Objects::nonNull));
    }

    @Override
    public <R> Steam<R> map(Function<? super T, ? extends R> mapper) {
        return new Steam<R>(this.stream.map(mapper));
    }

    public <R> Steam<R> mapIdx(BiFunction<? super T, Integer, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isParallel()) {
            return Steam.of(this.toIdxMap().entrySet()).parallel(this.isParallel()).map((T e) -> mapper.apply((Object)e.getValue(), (Integer)e.getKey()));
        }
        AtomicInteger index = new AtomicInteger(-1);
        return this.map((T e) -> mapper.apply(e, index.incrementAndGet()));
    }

    public Steam<T> peekIdx(SerBiCons<? super T, Integer> action) {
        Objects.requireNonNull(action);
        if (this.isParallel()) {
            return ((Steam)Steam.of(this.toIdxMap().entrySet()).parallel(this.isParallel()).peek(e -> action.accept((Object)e.getValue(), (Integer)e.getKey()))).map(Map.Entry::getValue);
        }
        AtomicInteger index = new AtomicInteger(-1);
        return (Steam)this.peek(e -> action.accept(e, index.incrementAndGet()));
    }

    @Override
    public <R> Steam<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Steam(this.stream.flatMap(mapper));
    }

    public <R> Steam<R> flatIdx(BiFunction<? super T, Integer, ? extends Iterable<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isParallel()) {
            return Steam.of(this.toIdxMap().entrySet()).parallel(this.isParallel()).flat(e -> (Iterable)mapper.apply((Object)e.getValue(), (Integer)e.getKey()));
        }
        AtomicInteger index = new AtomicInteger(-1);
        return this.flat(e -> (Iterable)mapper.apply(e, index.incrementAndGet()));
    }

    public <R> Steam<R> flat(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.flatMap((T w) -> Opp.of(w).map(mapper).map(Steam::of).orElseGet(Steam::empty));
    }

    @Override
    public <R> Steam<R> mapMulti(BiConsumer<? super T, ? super Consumer<R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.flatMap((T e) -> {
            Builder buffer = Steam.builder();
            mapper.accept(e, buffer);
            return buffer.build();
        });
    }

    public <F> Steam<T> distinct(Function<? super T, F> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        if (this.isParallel()) {
            ConcurrentHashMap exists = new ConcurrentHashMap(32);
            AtomicBoolean hasNull = new AtomicBoolean(false);
            return (Steam)Steam.of(this.stream.filter(e -> {
                Object key = keyExtractor.apply(e);
                if (key == null) {
                    if (hasNull.get()) {
                        return false;
                    }
                    hasNull.set(Boolean.TRUE);
                    return true;
                }
                return null == exists.putIfAbsent(key, Boolean.TRUE);
            })).parallel();
        }
        HashSet exists = new HashSet();
        return Steam.of(this.stream.filter(e -> exists.add(keyExtractor.apply(e))));
    }

    public Steam<T> log() {
        return (Steam)this.peek(s -> Logger.getGlobal().info(String.valueOf(s)));
    }

    public void forEachIdx(BiConsumer<? super T, Integer> action) {
        Objects.requireNonNull(action);
        if (this.isParallel()) {
            Steam.of(this.toIdxMap().entrySet()).parallel(this.isParallel()).forEach((T e) -> action.accept((Object)e.getValue(), (Integer)e.getKey()));
        } else {
            AtomicInteger index = new AtomicInteger(-1);
            this.stream.forEach((? super T e) -> action.accept(e, index.incrementAndGet()));
        }
    }

    public void forEachOrderedIdx(BiConsumer<? super T, Integer> action) {
        Objects.requireNonNull(action);
        if (this.isParallel()) {
            this.stream.forEachOrdered((? super T e) -> action.accept(e, -1));
        } else {
            AtomicInteger index = new AtomicInteger(-1);
            this.stream.forEachOrdered((? super T e) -> action.accept(e, index.incrementAndGet()));
        }
    }

    public Optional<T> findFirst(Predicate<? super T> predicate) {
        return this.stream.filter(predicate).findFirst();
    }

    public Integer findFirstIdx(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return ((Steam)this.mapIdx((e, i) -> Maps.entry(i, e)).filter(e -> predicate.test((Object)e.getValue()))).findFirst().map(Map.Entry::getKey).orElse(-1);
    }

    public Optional<T> findLast() {
        if (this.isParallel()) {
            return Optional.of(this.toList()).filter(l -> !l.isEmpty()).map((? super T l) -> l.get(l.size() - 1));
        }
        AtomicReference<Object> last = new AtomicReference<Object>(null);
        this.forEach(last::set);
        return Optional.ofNullable(last.get());
    }

    public Optional<T> findLast(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isParallel()) {
            return ((Steam)this.filter(predicate)).findLast();
        }
        AtomicReference<Object> last = new AtomicReference<Object>(null);
        this.forEach((T e) -> {
            if (predicate.test(e)) {
                last.set(e);
            }
        });
        return Optional.ofNullable(last.get());
    }

    public Integer findLastIdx(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return ((Steam)this.mapIdx((e, i) -> Maps.entry(i, e)).filter(e -> predicate.test((Object)e.getValue()))).findLast().map(Map.Entry::getKey).orElse(-1);
    }

    public Steam<T> reverseSorted(Comparator<T> comparator) {
        return (Steam)this.sorted(comparator.reversed());
    }

    public Steam<T> parallel(boolean parallel) {
        return parallel ? (Steam)this.parallel() : (Steam)this.sequential();
    }

    public Steam<T> push(T obj) {
        return Steam.concat(this.stream, Stream.of(obj));
    }

    public Steam<T> push(T ... obj) {
        return Steam.concat(this.stream, Steam.of(obj));
    }

    public Steam<T> unshift(T obj) {
        return Steam.concat(Stream.of(obj), this.stream);
    }

    @SafeVarargs
    public final Steam<T> unshift(T ... obj) {
        return Steam.concat(Steam.of(obj), this.stream);
    }

    public Optional<T> at(Integer idx) {
        if (Objects.isNull(idx)) {
            return Optional.empty();
        }
        Optional<List<List>> listOpt = Optional.of(this.toList());
        if (idx > -1) {
            return listOpt.filter(l -> idx < l.size()).map((? super T l) -> l.get(idx));
        }
        return listOpt.filter(l -> -idx.intValue() <= l.size()).map((? super T l) -> l.get(l.size() + idx));
    }

    @Override
    protected Steam<T> wrap(Stream<T> stream) {
        return new Steam<T>(stream);
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Stream) {
            return this.stream.equals(obj);
        }
        return false;
    }

    public String toString() {
        return this.stream.toString();
    }

    public <U, R> Steam<R> zip(Iterable<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        Objects.requireNonNull(zipper);
        Map idxIdentityMap = this.toIdxMap();
        Map idxOtherMap = Steam.of(other).toIdxMap();
        if (idxIdentityMap.size() <= idxOtherMap.size()) {
            return Steam.of(idxIdentityMap.keySet(), this.isParallel()).map((T k) -> zipper.apply((Object)idxIdentityMap.get(k), (Object)idxOtherMap.get(k)));
        }
        return Steam.of(idxOtherMap.keySet(), this.isParallel()).map((T k) -> zipper.apply((Object)idxIdentityMap.get(k), (Object)idxOtherMap.get(k)));
    }

    public <R> Steam<T> filterContains(Function<? super T, ? extends R> mapper, Iterable<T> others) {
        List otherList = Steam.of(others).map((Function)mapper).toList();
        return (Steam)this.filter(a -> Objects.nonNull(a) && otherList.contains(mapper.apply(a)));
    }

    public Steam<T> splice(int start, int deleteCount, T ... items) {
        List list = this.toList();
        int size = list.size();
        if (start < 0) {
            start += size;
        } else if (start >= size) {
            start = size;
            deleteCount = 0;
        }
        if (start + deleteCount > size) {
            deleteCount = size - start;
        }
        int newSize = size - deleteCount + items.length;
        List resList = list;
        if (newSize > size) {
            resList = new ArrayList(newSize);
            resList.addAll(list);
        }
        if (deleteCount > 0) {
            resList.subList(start, start + deleteCount).clear();
        }
        if (items.length > 0) {
            resList.addAll(start, Arrays.asList(items));
        }
        return Steam.of(resList);
    }

    public Steam<Steam<T>> split(int batchSize) {
        List list = this.toList();
        int size = list.size();
        if (size <= batchSize) {
            return Steam.of(Steam.of(list, this.isParallel()));
        }
        return ((Steam)Steam.iterate(0, i -> i < size, i -> i + batchSize).map((T skip) -> Steam.of(list.subList((int)skip, Math.min(size, skip + batchSize)), this.isParallel()))).parallel(this.isParallel());
    }

    public Steam<List<T>> splitList(int batchSize) {
        return this.split(batchSize).map(CollectableStream::toList);
    }

    public static interface Builder<T>
    extends Consumer<T> {
        @Override
        public void accept(T var1);

        default public Builder<T> add(T t) {
            this.accept(t);
            return this;
        }

        public Steam<T> build();
    }
}

