/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.config;

import java.io.Serializable;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.expression.ExpressionStrategy;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.json.JsonConvert;
import org.dromara.warm.flow.core.utils.ExpressionUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.ServiceLoaderUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.core.utils.VariableUtil;
import org.dromara.warm.flow.core.variable.VariableStrategy;

public class WarmFlow
implements Serializable {
    private boolean enabled = true;
    private boolean banner = true;
    private String keyType;
    private boolean logicDelete = false;
    private String logicDeleteValue = "2";
    private String logicNotDeleteValue = "0";
    private String dataFillHandlerPath;
    private String tenantHandlerPath;
    private String dataSourceType;
    private boolean ui = true;

    public static WarmFlow init() {
        String keyType;
        String ui;
        WarmFlow flowConfig = new WarmFlow();
        String banner = FrameInvoker.getCfg("warm-flow.banner");
        if (StringUtils.isNotEmpty(banner)) {
            flowConfig.setBanner(ObjectUtil.isStrTrue(banner));
        }
        if (StringUtils.isNotEmpty(ui = FrameInvoker.getCfg("warm-flow.ui"))) {
            flowConfig.setUi(ObjectUtil.isStrTrue(ui));
        }
        if (StringUtils.isNotEmpty(keyType = FrameInvoker.getCfg("warm-flow.key_type"))) {
            flowConfig.setKeyType(keyType);
        }
        WarmFlow.setLogicDelete(flowConfig);
        flowConfig.setTenantHandlerPath(FrameInvoker.getCfg("warm-flow.tenant_handler_path"));
        flowConfig.setDataFillHandlerPath(FrameInvoker.getCfg("warm-flow.data-fill-handler-path"));
        flowConfig.setDataSourceType(FrameInvoker.getCfg("warm-flow.data_source_type"));
        WarmFlow.printBanner(flowConfig);
        WarmFlow.spiLoad();
        return flowConfig;
    }

    public static void spiLoad() {
        ServiceLoaderUtil.loadList(ExpressionStrategy.class).forEach(ExpressionUtil::setExpression);
        ServiceLoaderUtil.loadList(VariableStrategy.class).forEach(VariableUtil::setExpression);
        FlowFactory.jsonConvert(ServiceLoaderUtil.loadFirst(JsonConvert.class));
    }

    private static void setLogicDelete(WarmFlow flowConfig) {
        String logicDelete = FrameInvoker.getCfg("warm-flow.logic_delete");
        if (ObjectUtil.isStrTrue(logicDelete)) {
            String logicNotDeleteValue;
            flowConfig.setLogicDelete(ObjectUtil.isStrTrue(logicDelete));
            String logicDeleteValue = FrameInvoker.getCfg("warm-flow.logic_delete_value");
            if (StringUtils.isNotEmpty(logicDeleteValue)) {
                flowConfig.setLogicDeleteValue(logicDeleteValue);
            }
            if (StringUtils.isNotEmpty(logicNotDeleteValue = FrameInvoker.getCfg("warm-flow.logic_not_delete_value"))) {
                flowConfig.setLogicNotDeleteValue(logicNotDeleteValue);
            }
        }
    }

    private static void printBanner(WarmFlow flowConfig) {
        if (flowConfig.isBanner()) {
            System.out.println("\n   \u2584     \u2584                      \u2584\u2584\u2584\u2584\u2584\u2584   \u2584                     \n   \u2588  \u2588  \u2588  \u2584\u2584\u2584    \u2584 \u2584\u2584  \u2584\u2584\u2584\u2584\u2584  \u2588        \u2588     \u2584\u2584\u2584  \u2584     \u2584    \n   \u2580 \u2588\u2580\u2588 \u2588 \u2580   \u2588   \u2588\u2580  \u2580 \u2588 \u2588 \u2588  \u2588\u2584\u2584\u2584\u2584\u2584   \u2588    \u2588\u2580 \u2580\u2588 \u2580\u2584 \u2584 \u2584\u2580    \n    \u2588\u2588 \u2588\u2588\u2580 \u2584\u2580\u2580\u2580\u2588   \u2588     \u2588 \u2588 \u2588  \u2588        \u2588    \u2588   \u2588  \u2588\u2584\u2588\u2584\u2588     \n    \u2588   \u2588  \u2580\u2584\u2584\u2580\u2588   \u2588     \u2588 \u2588 \u2588  \u2588        \u2580\u2584\u2584  \u2580\u2588\u2584\u2588\u2580   \u2588 \u2588      \n\n\u001b[32m   :: Warm-Flow ::     (v" + WarmFlow.class.getPackage().getImplementationVersion() + ")\u001b[0m\n");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isBanner() {
        return this.banner;
    }

    public void setBanner(boolean banner) {
        this.banner = banner;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public void setLogicDelete(boolean logicDelete) {
        this.logicDelete = logicDelete;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public void setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }

    public String getDataFillHandlerPath() {
        return this.dataFillHandlerPath;
    }

    public void setDataFillHandlerPath(String dataFillHandlerPath) {
        this.dataFillHandlerPath = dataFillHandlerPath;
    }

    public String getTenantHandlerPath() {
        return this.tenantHandlerPath;
    }

    public void setTenantHandlerPath(String tenantHandlerPath) {
        this.tenantHandlerPath = tenantHandlerPath;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(String dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public boolean isUi() {
        return this.ui;
    }

    public void setUi(boolean ui) {
        this.ui = ui;
    }
}

