/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.keygen;

import org.dromara.warm.flow.core.keygen.KenGen;

public class SnowFlakeId14
implements KenGen {
    private final long startTime = 1683803335498L;
    private final long workerIdBits = 3L;
    private final long maxWorkerId = 7L;
    private final long sequenceBits = 5L;
    private final long workerIdShift = 5L;
    private final long timestampLeftShift = 8L;
    private final long sequenceMask = 31L;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowFlakeId14(long workerId) {
        if (workerId > 7L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("workerId can't be greater than %d or less than 0", 7L));
        }
        this.workerId = workerId;
    }

    @Override
    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x1FL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1683803335498L << 8 | this.workerId << 5 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }
}

