/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.orm.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.dao.WarmDao;
import org.dromara.warm.flow.core.handler.DataFillHandler;
import org.dromara.warm.flow.core.orm.agent.WarmQuery;
import org.dromara.warm.flow.core.orm.service.IWarmService;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.SqlHelper;
import org.dromara.warm.flow.core.utils.page.Page;

public abstract class WarmServiceImpl<M extends WarmDao<T>, T>
implements IWarmService<T> {
    protected M warmDao;

    @Override
    public M getDao() {
        return this.warmDao;
    }

    protected abstract IWarmService<T> setDao(M var1);

    @Override
    public T getById(Serializable id) {
        return this.getDao().selectById(id);
    }

    @Override
    public List<T> getByIds(Collection<? extends Serializable> ids) {
        return this.getDao().selectByIds(ids);
    }

    @Override
    public Page<T> page(T entity, Page<T> page) {
        return this.getDao().selectPage(entity, page);
    }

    @Override
    public List<T> list(T entity) {
        return this.getDao().selectList(entity, null);
    }

    @Override
    public List<T> list(T entity, WarmQuery<T> query) {
        return this.getDao().selectList(entity, query);
    }

    @Override
    public T getOne(T entity) {
        List<T> list = this.getDao().selectList(entity, null);
        return CollUtil.getOne(list);
    }

    @Override
    public long selectCount(T entity) {
        return this.getDao().selectCount(entity);
    }

    @Override
    public Boolean exists(T entity) {
        long count = this.selectCount(entity);
        return count > 0L;
    }

    @Override
    public boolean save(T entity) {
        this.insertFill(entity);
        return SqlHelper.retBool(this.getDao().save(entity));
    }

    @Override
    public boolean updateById(T entity) {
        this.updateFill(entity);
        return SqlHelper.retBool(this.getDao().updateById(entity));
    }

    @Override
    public boolean removeById(Serializable id) {
        return SqlHelper.retBool(this.getDao().deleteById(id));
    }

    @Override
    public boolean remove(T entity) {
        return SqlHelper.retBool(this.getDao().delete(entity));
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> ids) {
        return SqlHelper.retBool(this.getDao().deleteByIds(ids));
    }

    @Override
    public void saveBatch(List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        this.saveBatch(list, 100);
    }

    @Override
    public void saveBatch(List<T> list, int batchSize) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<List<T>> split = CollUtil.split(list, batchSize > 0 ? batchSize : 100);
        for (List<Object> list2 : split) {
            list2.forEach(this::insertFill);
            this.getDao().saveBatch(list2);
        }
    }

    @Override
    public void updateBatch(List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        list.forEach(this::updateFill);
        this.getDao().updateBatch(list);
    }

    @Override
    public WarmQuery<T> orderById() {
        return new WarmQuery(this).orderById();
    }

    @Override
    public WarmQuery<T> orderByCreateTime() {
        return new WarmQuery(this).orderByCreateTime();
    }

    @Override
    public WarmQuery<T> orderByUpdateTime() {
        return new WarmQuery(this).orderByUpdateTime();
    }

    @Override
    public WarmQuery<T> orderByAsc(String orderByField) {
        return new WarmQuery(this).orderByAsc(orderByField);
    }

    @Override
    public WarmQuery<T> orderByDesc(String orderByField) {
        return new WarmQuery(this).orderByDesc(orderByField);
    }

    @Override
    public WarmQuery<T> orderBy(String orderByField) {
        return new WarmQuery(this).orderBy(orderByField);
    }

    public void insertFill(T entity) {
        DataFillHandler dataFillHandler = FlowFactory.dataFillHandler();
        if (ObjectUtil.isNotNull(dataFillHandler)) {
            dataFillHandler.idFill(entity);
            dataFillHandler.insertFill(entity);
        }
    }

    public void updateFill(T entity) {
        DataFillHandler dataFillHandler = FlowFactory.dataFillHandler();
        if (ObjectUtil.isNotNull(dataFillHandler)) {
            dataFillHandler.updateFill(entity);
        }
    }
}

