/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class ClassUtil {
    public static Class<?> getClazz(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <C> C clone(C origin) {
        if (Objects.isNull(origin)) {
            return null;
        }
        try {
            Field[] fields;
            Class<?> clazz = origin.getClass();
            Constructor<?> constructors = clazz.getConstructor(new Class[0]);
            Object instance = constructors.newInstance(new Object[0]);
            for (Field field : fields = clazz.getDeclaredFields()) {
                ClassUtil.makeAccessible(field);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                Object value = field.get(origin);
                field.set(instance, value);
            }
            return (C)instance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }
}

