/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dromara.warm.flow.core.utils.ArrayUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class CollUtil {
    public static boolean isEmpty(Collection<?> coll) {
        return ObjectUtil.isNull(coll) || coll.isEmpty();
    }

    public static <T> T getOne(List<T> list) {
        return CollUtil.isEmpty(list) ? null : (T)list.get(0);
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollUtil.isEmpty(coll);
    }

    public static <T> List<T> emptyDefault(List<T> list, List<T> defaultList) {
        return CollUtil.isEmpty(list) ? defaultList : list;
    }

    public static boolean containsAny(Collection<String> collection, String ... array) {
        if (CollUtil.isEmpty(collection) || ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (String str : array) {
            if (!collection.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<String> collection1, Collection<String> collection2) {
        if (CollUtil.isEmpty(collection1) || CollUtil.isEmpty(collection2)) {
            return false;
        }
        for (String str : collection2) {
            if (!collection1.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean notContainsAny(Collection<String> collection1, Collection<String> collection2) {
        return !CollUtil.containsAny(collection1, collection2);
    }

    public static List<String> strToColl(String str, String sep) {
        return StringUtils.isEmpty(str) ? null : Arrays.asList(str.split(sep));
    }

    public static <T> List<T> listAddToNew(List<T> list, T t) {
        return CollUtil.listAddToNew(list, Collections.singletonList(t));
    }

    public static <T> List<T> listAddToNew(List<T> list, List<T> listA) {
        ArrayList<T> newList = new ArrayList<T>();
        newList.addAll(listA);
        newList.addAll(list);
        return newList;
    }

    public static <T> List<T> toList(T ... paramArr) {
        if (ArrayUtil.isEmpty(paramArr)) {
            return new ArrayList();
        }
        ArrayList<T> arrayList = new ArrayList<T>(paramArr.length);
        arrayList.addAll(Arrays.asList(paramArr));
        return arrayList;
    }

    public static <T> List<T> listAddListsToNew(List<T> list, List<List<T>> lists) {
        ArrayList<T> newList = new ArrayList<T>();
        if (CollUtil.isNotEmpty(lists)) {
            for (List<T> ts : lists) {
                if (!CollUtil.isNotEmpty(ts)) continue;
                newList.addAll(ts);
            }
        }
        if (CollUtil.isNotEmpty(list)) {
            newList.addAll(list);
        }
        return newList;
    }

    public static String strListToStr(List<String> list, String sep) {
        StringBuilder sb = new StringBuilder();
        if (CollUtil.isNotEmpty(list)) {
            for (String str : list) {
                sb.append(str).append(sep);
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static <T> List<List<T>> split(List<T> list, int batchSize) {
        int N = (int)Math.ceil((double)list.size() / (double)batchSize);
        return IntStream.range(0, N).boxed().map(i -> list.subList(i * batchSize, Math.min((i + 1) * batchSize, list.size()))).collect(Collectors.toList());
    }
}

