/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.ActivityStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class FlowConfigUtil {
    private FlowConfigUtil() {
    }

    public static FlowCombine readConfig(InputStream is) throws Exception {
        Definition definition = FlowConfigUtil.readDocument(is);
        return FlowConfigUtil.structureFlow(definition);
    }

    public static Definition readDocument(InputStream is) throws Exception {
        AssertUtil.isNull(is, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        Element definitionElement = new SAXReader().read(is).getRootElement();
        AssertUtil.isNull(definitionElement, "\u6d41\u7a0b\u4e3a\u7a7a\uff01");
        Definition definition = FlowFactory.newDef();
        definition.setFlowCode(definitionElement.attributeValue("flowCode"));
        definition.setFlowName(definitionElement.attributeValue("flowName"));
        definition.setVersion(definitionElement.attributeValue("version"));
        definition.setCategory(definitionElement.attributeValue("category"));
        definition.setFormCustom(definitionElement.attributeValue("formCustom"));
        definition.setFormPath(definitionElement.attributeValue("formPath"));
        definition.setExt(definitionElement.attributeValue("ext"));
        definition.setActivityStatus(ActivityStatus.ACTIVITY.getKey());
        definition.setListenerType(definitionElement.attributeValue("listenerType"));
        definition.setListenerPath(definitionElement.attributeValue("listenerPath"));
        List nodesElement = definitionElement.elements();
        List<Node> nodeList = definition.getNodeList();
        for (Element nodeElement : nodesElement) {
            Node node = FlowConfigUtil.initNodeAndCondition(nodeElement);
            nodeList.add(node);
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return definition;
    }

    private static Node initNodeAndCondition(Element nodeElement) {
        Node node = FlowFactory.newNode();
        node.setNodeType(NodeType.getKeyByValue(nodeElement.attributeValue("nodeType")));
        node.setNodeCode(nodeElement.attributeValue("nodeCode"));
        node.setNodeName(nodeElement.attributeValue("nodeName"));
        node.setPermissionFlag(nodeElement.attributeValue("permissionFlag"));
        if (StringUtils.isNotEmpty(nodeElement.attributeValue("nodeRatio"))) {
            node.setNodeRatio(new BigDecimal(nodeElement.attributeValue("nodeRatio")));
        } else {
            node.setNodeRatio(new BigDecimal("0"));
        }
        node.setCoordinate(nodeElement.attributeValue("coordinate"));
        node.setSkipAnyNode(nodeElement.attributeValue("skipAnyNode"));
        node.setListenerType(nodeElement.attributeValue("listenerType"));
        node.setListenerPath(nodeElement.attributeValue("listenerPath"));
        node.setHandlerType(nodeElement.attributeValue("handlerType"));
        node.setHandlerPath(nodeElement.attributeValue("handlerPath"));
        node.setFormCustom(nodeElement.attributeValue("formCustom"));
        node.setFormPath(nodeElement.attributeValue("formPath"));
        FlowFactory.dataFillHandler().idFill(node);
        List skipsElement = nodeElement.elements();
        List<Skip> skips = node.getSkipList();
        for (Element skipElement : skipsElement) {
            Skip skip = FlowFactory.newSkip();
            if (!"skip".equals(skipElement.getName())) continue;
            skip.setNowNodeCode(node.getNodeCode());
            skip.setNowNodeType(node.getNodeType());
            skip.setNextNodeCode(skipElement.getText());
            skip.setSkipName(skipElement.attributeValue("skipName"));
            skip.setSkipType(skipElement.attributeValue("skipType"));
            skip.setCoordinate(skipElement.attributeValue("coordinate"));
            skip.setSkipCondition(skipElement.attributeValue("skipCondition"));
            skips.add(skip);
        }
        return node;
    }

    public static Document createDocument(Definition definition) {
        Document document = DocumentHelper.createDocument();
        Element definitionElement = document.addElement("definition");
        definitionElement.addAttribute("flowCode", definition.getFlowCode());
        definitionElement.addAttribute("flowName", definition.getFlowName());
        definitionElement.addAttribute("version", definition.getVersion());
        definitionElement.addAttribute("category", definition.getCategory());
        definitionElement.addAttribute("formCustom", definition.getFormCustom());
        definitionElement.addAttribute("formPath", definition.getFormPath());
        definitionElement.addAttribute("listenerType", definition.getListenerType());
        definitionElement.addAttribute("listenerPath", definition.getListenerPath());
        definitionElement.addAttribute("ext", definition.getExt());
        List<Node> nodeList = definition.getNodeList();
        for (Node node : nodeList) {
            Element nodeElement = definitionElement.addElement("node");
            nodeElement.addAttribute("nodeType", NodeType.getValueByKey(node.getNodeType()));
            nodeElement.addAttribute("nodeCode", node.getNodeCode());
            nodeElement.addAttribute("nodeName", node.getNodeName());
            nodeElement.addAttribute("permissionFlag", node.getPermissionFlag());
            if (Objects.nonNull(node.getNodeRatio())) {
                nodeElement.addAttribute("nodeRatio", node.getNodeRatio().toString());
            }
            nodeElement.addAttribute("coordinate", node.getCoordinate());
            nodeElement.addAttribute("skipAnyNode", node.getSkipAnyNode());
            nodeElement.addAttribute("listenerType", node.getListenerType());
            nodeElement.addAttribute("listenerPath", node.getListenerPath());
            nodeElement.addAttribute("handlerType", node.getHandlerType());
            nodeElement.addAttribute("handlerPath", node.getHandlerPath());
            nodeElement.addAttribute("formCustom", node.getFormCustom());
            nodeElement.addAttribute("formPath", node.getFormPath());
            List<Skip> skipList = node.getSkipList();
            if (!CollUtil.isNotEmpty(skipList)) continue;
            for (Skip skip : skipList) {
                Element skipElement = nodeElement.addElement("skip");
                skipElement.addAttribute("coordinate", skip.getCoordinate());
                if (StringUtils.isNotEmpty(skip.getSkipType())) {
                    AssertUtil.isFalse(StringUtils.isNotEmpty(skip.getNextNodeCode()), "\u4e0b\u4e00\u4e2a\u6d41\u7a0b\u8282\u70b9\u7f16\u7801\u4e3a\u7a7a");
                    skipElement.addAttribute("skipType", skip.getSkipType());
                }
                if (StringUtils.isNotEmpty(skip.getSkipName())) {
                    skipElement.addAttribute("skipName", skip.getSkipName());
                }
                if (StringUtils.isNotEmpty(skip.getSkipCondition())) {
                    skipElement.addAttribute("skipCondition", skip.getSkipCondition());
                }
                skipElement.addText(skip.getNextNodeCode());
            }
        }
        return document;
    }

    private static FlowCombine structureFlow(Definition definition) {
        FlowCombine combine = new FlowCombine();
        combine.setDefinition(definition);
        List<Node> allNodes = combine.getAllNodes();
        List<Skip> allSkips = combine.getAllSkips();
        String flowName = definition.getFlowName();
        AssertUtil.isEmpty(definition.getFlowCode(), "\u3010" + flowName + "\u3011\u6d41\u7a0bflowCode\u4e3a\u7a7a!");
        definition.setIsPublish(0);
        definition.setUpdateTime(new Date());
        FlowFactory.dataFillHandler().idFill(definition);
        List<Node> nodeList = definition.getNodeList();
        int startNum = 0;
        HashSet<String> nodeCodeSet = new HashSet<String>();
        for (Node node : nodeList) {
            FlowConfigUtil.initNodeAndCondition(node, definition.getId(), definition.getVersion());
            if (NodeType.isStart(node.getNodeType()).booleanValue()) {
                AssertUtil.isTrue(++startNum > 1, "[" + flowName + "]" + "\u5f00\u59cb\u8282\u70b9\u4e0d\u80fd\u8d85\u8fc71\u4e2a!");
            }
            AssertUtil.contains(nodeCodeSet, node.getNodeCode(), "\u3010" + flowName + "\u3011" + "\u540c\u4e00\u6d41\u7a0b\u4e2d\u8282\u70b9\u7f16\u7801\u91cd\u590d!");
            nodeCodeSet.add(node.getNodeCode());
            allNodes.add(node);
            allSkips.addAll(node.getSkipList());
        }
        Map<String, Integer> skipMap = StreamUtils.toMap(allNodes, Node::getNodeCode, Node::getNodeType);
        allSkips.forEach(allSkip -> allSkip.setNextNodeType((Integer)skipMap.get(allSkip.getNextNodeCode())));
        AssertUtil.isTrue(startNum == 0, "[" + flowName + "]" + "\u6d41\u7a0b\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9!");
        FlowConfigUtil.checkSkipNode(allSkips);
        FlowConfigUtil.validaIsExistDestNode(allSkips, nodeCodeSet);
        return combine;
    }

    private static void checkSkipNode(List<Skip> allSkips) {
        Map<String, List<Skip>> allSkipMap = StreamUtils.groupByKey(allSkips, Skip::getNowNodeCode);
        allSkipMap.forEach((key, values) -> {
            AtomicInteger passNum = new AtomicInteger();
            AtomicInteger rejectNum = new AtomicInteger();
            for (Skip value : values) {
                if (!NodeType.isBetween(value.getNowNodeType()).booleanValue() || !NodeType.isBetween(value.getNextNodeType()).booleanValue()) continue;
                if (SkipType.isPass(value.getSkipType()).booleanValue()) {
                    passNum.getAndIncrement();
                    continue;
                }
                rejectNum.getAndIncrement();
            }
            AssertUtil.isTrue(passNum.get() > 1 || rejectNum.get() > 1, "\u4e0d\u53ef\u540c\u65f6\u901a\u8fc7\u6216\u8005\u9000\u56de\u5230\u591a\u4e2a\u4e2d\u95f4\u8282\u70b9\uff0c\u5fc5\u987b\u5148\u6d41\u8f6c\u5230\u7f51\u5173\u8282\u70b9!");
        });
    }

    private static void validaIsExistDestNode(List<Skip> allSkips, Set<String> nodeCodeSet) {
        for (int i = 0; i < allSkips.size(); ++i) {
            String nextNodeCode = allSkips.get(i).getNextNodeCode();
            AssertUtil.isTrue(!nodeCodeSet.contains(nextNodeCode), "\u3010" + nextNodeCode + "\u3011" + "\u76ee\u6807\u8282\u70b9\u7f16\u7801\u4e0d\u5b58\u5728!");
        }
    }

    private static void initNodeAndCondition(Node node, Long definitionId, String version) {
        String nodeName = node.getNodeName();
        String nodeCode = node.getNodeCode();
        List<Skip> skipList = node.getSkipList();
        if (!NodeType.isEnd(node.getNodeType()).booleanValue()) {
            AssertUtil.isEmpty(skipList, "\u5f00\u59cb\u548c\u4e2d\u95f4\u8282\u70b9\u5fc5\u987b\u6709\u8df3\u8f6c\u89c4\u5219");
        }
        AssertUtil.isEmpty(nodeCode, "[" + nodeName + "]" + "\u8282\u70b9\u7f16\u7801\u7f3a\u5931");
        node.setVersion(version);
        node.setDefinitionId(definitionId);
        node.setUpdateTime(new Date());
        HashSet<String> betweenSet = new HashSet<String>();
        HashSet<String> gateWaySet = new HashSet<String>();
        int skipNum = 0;
        for (Skip skip : skipList) {
            String target;
            if (NodeType.isStart(node.getNodeType()).booleanValue()) {
                AssertUtil.isTrue(++skipNum > 1, "[" + node.getNodeName() + "]" + "\u8282\u70b9\u6d41\u8f6c\u6761\u4ef6\u4e0d\u80fd\u8d85\u8fc71\u4e2a!");
            }
            AssertUtil.isEmpty(skip.getNextNodeCode(), "\u3010" + nodeName + "\u3011" + "\u76ee\u6807\u8282\u70b9\u4e3a\u7a7a!");
            FlowFactory.dataFillHandler().idFill(skip);
            skip.setDefinitionId(definitionId);
            skip.setNodeId(node.getId());
            if (NodeType.isGateWaySerial(node.getNodeType()).booleanValue()) {
                target = skip.getSkipCondition() + ":" + skip.getNextNodeCode();
                AssertUtil.contains(gateWaySet, target, "[" + nodeName + "]" + "\u4e92\u65a5\u7f51\u5173\uff0c\u540c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6709\u76f8\u540c\u8df3\u8f6c\u6761\u4ef6\uff0c\u8df3\u8f6c\u540c\u4e00\u4e2a\u76ee\u6807\u8282\u70b9!");
                gateWaySet.add(target);
                continue;
            }
            if (NodeType.isGateWayParallel(node.getNodeType()).booleanValue()) {
                target = skip.getNextNodeCode();
                AssertUtil.contains(gateWaySet, target, "[" + nodeName + "]" + "\u5e76\u884c\u7f51\u5173\uff0c\u540c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u8df3\u8f6c\u540c\u4e00\u4e2a\u76ee\u6807\u8282\u70b9!");
                gateWaySet.add(target);
                continue;
            }
            String value = skip.getSkipType() + ":" + skip.getNextNodeCode();
            AssertUtil.contains(betweenSet, value, "[" + nodeName + "]" + "\u4e2d\u95f4\u8282\u70b9\uff0c\u540c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6709\u76f8\u540c\u8df3\u8f6c\u7c7b\u578b\uff0c\u8df3\u8f6c\u540c\u4e00\u4e2a\u76ee\u6807\u8282\u70b9!");
            betweenSet.add(value);
        }
    }
}

