/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.HashMap;
import java.util.regex.Matcher;
import org.dromara.warm.flow.core.constant.FlowCons;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.listener.Listener;
import org.dromara.warm.flow.core.listener.ListenerVariable;
import org.dromara.warm.flow.core.listener.NodePermission;
import org.dromara.warm.flow.core.listener.ValueHolder;
import org.dromara.warm.flow.core.utils.ClassUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class ListenerUtil {
    private ListenerUtil() {
    }

    public static void executeGetNodePermission(ListenerVariable listenerVariable) {
        for (Node node : listenerVariable.getNextNodes()) {
            NodePermission permissionByNode;
            if (!StringUtils.isNotEmpty(node.getListenerType()) || !node.getListenerType().contains("permission")) continue;
            ListenerUtil.executeListener(listenerVariable, "permission", node);
            if (!CollUtil.isNotEmpty(listenerVariable.getNodePermissionList()) || !ObjectUtil.isNotNull(permissionByNode = listenerVariable.getPermissionByNode(node.getNodeCode())) || !StringUtils.isNotEmpty(permissionByNode.getPermissionFlag())) continue;
            if (CollUtil.isNotEmpty(permissionByNode.getPermissionFlagList())) {
                node.setDynamicPermissionFlagList(permissionByNode.getPermissionFlagList());
                continue;
            }
            if (!StringUtils.isNotEmpty(permissionByNode.getPermissionFlag())) continue;
            node.setDynamicPermissionFlagList(CollUtil.strToColl(permissionByNode.getPermissionFlag(), ","));
        }
    }

    public static void endCreateListener(ListenerVariable listenerVariable) {
        ListenerUtil.executeListener(listenerVariable, "finish");
        listenerVariable.getNextNodes().forEach(node -> ListenerUtil.executeListener(listenerVariable, "create", node));
    }

    public static void executeListener(ListenerVariable listenerVariable, String lisType) {
        ListenerUtil.executeListener(listenerVariable, lisType, listenerVariable.getNode());
    }

    public static void executeListener(ListenerVariable listenerVariable, String lisType, Node listenerNode) {
        String listenerType = listenerNode.getListenerType();
        ListenerUtil.execute(listenerVariable, lisType, listenerNode.getListenerPath(), listenerType);
        Definition definition = listenerVariable.getDefinition();
        ListenerUtil.execute(listenerVariable, lisType, definition.getListenerPath(), definition.getListenerType());
    }

    private static void execute(ListenerVariable listenerVariable, String lisType, String listenerPathStr, String lisListType) {
        if (StringUtils.isNotEmpty(lisListType)) {
            String[] listenerTypeArr = lisListType.split(",");
            for (int i = 0; i < listenerTypeArr.length; ++i) {
                Listener listener;
                String listenerTypeStr = listenerTypeArr[i].trim();
                if (!listenerTypeStr.equals(lisType) || !StringUtils.isNotEmpty(listenerPathStr)) continue;
                String[] listenerPathArr = listenerPathStr.split("@@");
                String listenerPath = listenerPathArr[i].trim();
                ValueHolder valueHolder = new ValueHolder();
                ListenerUtil.getListenerPath(listenerPath, valueHolder);
                Class<?> clazz = ClassUtil.getClazz(valueHolder.getPath());
                if (!ObjectUtil.isNotNull(clazz) || !Listener.class.isAssignableFrom(clazz) || !ObjectUtil.isNotNull(listener = (Listener)FrameInvoker.getBean(clazz))) continue;
                HashMap<String, Object> variable = listenerVariable.getVariable();
                variable = MapUtil.isEmpty(variable) ? new HashMap<String, Object>() : variable;
                variable.put("WarmListenerParam", valueHolder.getParams());
                listener.notify(listenerVariable.setVariable(variable));
            }
        }
    }

    public static void getListenerPath(String listenerStr, ValueHolder valueHolder) {
        Matcher matcher = FlowCons.listenerPattern.matcher(listenerStr);
        if (matcher.find()) {
            String path = matcher.group(1).replaceAll("[\\(\\)]", "");
            String params = matcher.group(2).replaceAll("[\\(\\)]", "");
            valueHolder.setPath(path);
            valueHolder.setParams(params);
        }
    }
}

