/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.core.variable.DefaultVariableStrategy;
import org.dromara.warm.flow.core.variable.VariableStrategy;

public class VariableUtil {
    private static final Map<String, VariableStrategy> map = new HashMap<String, VariableStrategy>();

    private VariableUtil() {
    }

    public static void setExpression(VariableStrategy variableStrategy) {
        map.put(variableStrategy.getType(), variableStrategy);
    }

    public static String eval(String expression, Map<String, Object> variable) {
        if (StringUtils.isNotEmpty(expression)) {
            AtomicReference result = new AtomicReference();
            map.forEach((k, v) -> {
                if (expression.startsWith(k + "|")) {
                    if (v == null) {
                        throw new FlowException("\u6761\u4ef6\u8868\u8fbe\u5f0f\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a!");
                    }
                    result.set(v.eval(expression.replace(k + "|", ""), variable));
                }
            });
            if (StringUtils.isNotEmpty((String)result.get())) {
                return (String)result.get();
            }
        }
        return expression;
    }

    static {
        VariableUtil.setExpression(new DefaultVariableStrategy());
    }
}

