/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core;

import java.util.function.Supplier;
import org.dromara.warm.flow.core.config.WarmFlow;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.handler.DataFillHandler;
import org.dromara.warm.flow.core.handler.TenantHandler;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.json.JsonConvert;
import org.dromara.warm.flow.core.service.DefService;
import org.dromara.warm.flow.core.service.HisTaskService;
import org.dromara.warm.flow.core.service.InsService;
import org.dromara.warm.flow.core.service.NodeService;
import org.dromara.warm.flow.core.service.SkipService;
import org.dromara.warm.flow.core.service.TaskService;
import org.dromara.warm.flow.core.service.UserService;
import org.dromara.warm.flow.core.utils.ClassUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class FlowFactory {
    private static DefService defService = null;
    private static HisTaskService hisTaskService = null;
    private static InsService insService = null;
    private static NodeService nodeService = null;
    private static SkipService skipService = null;
    private static TaskService taskService = null;
    private static UserService UserService = null;
    private static Supplier<Definition> defSupplier;
    private static Supplier<HisTask> hisTaskSupplier;
    private static Supplier<Instance> insSupplier;
    private static Supplier<Node> nodeSupplier;
    private static Supplier<Skip> skipSupplier;
    private static Supplier<Task> taskSupplier;
    private static Supplier<User> userSupplier;
    private static WarmFlow flowConfig;
    private static DataFillHandler dataFillHandler;
    private static boolean tenantHandlerFlag;
    private static TenantHandler tenantHandler;
    public static JsonConvert jsonConvert;

    public static DefService defService() {
        if (ObjectUtil.isNotNull(defService)) {
            return defService;
        }
        defService = FrameInvoker.getBean(DefService.class);
        return defService;
    }

    public static HisTaskService hisTaskService() {
        if (ObjectUtil.isNotNull(hisTaskService)) {
            return hisTaskService;
        }
        hisTaskService = FrameInvoker.getBean(HisTaskService.class);
        return hisTaskService;
    }

    public static InsService insService() {
        if (ObjectUtil.isNotNull(insService)) {
            return insService;
        }
        insService = FrameInvoker.getBean(InsService.class);
        return insService;
    }

    public static NodeService nodeService() {
        if (ObjectUtil.isNotNull(nodeService)) {
            return nodeService;
        }
        nodeService = FrameInvoker.getBean(NodeService.class);
        return nodeService;
    }

    public static SkipService skipService() {
        if (ObjectUtil.isNotNull(skipService)) {
            return skipService;
        }
        skipService = FrameInvoker.getBean(SkipService.class);
        return skipService;
    }

    public static TaskService taskService() {
        if (ObjectUtil.isNotNull(taskService)) {
            return taskService;
        }
        taskService = FrameInvoker.getBean(TaskService.class);
        return taskService;
    }

    public static UserService userService() {
        if (ObjectUtil.isNotNull(UserService)) {
            return UserService;
        }
        UserService = FrameInvoker.getBean(UserService.class);
        return UserService;
    }

    public static void setNewDef(Supplier<Definition> supplier) {
        defSupplier = supplier;
    }

    public static Definition newDef() {
        return defSupplier.get();
    }

    public static void setNewHisTask(Supplier<HisTask> supplier) {
        hisTaskSupplier = supplier;
    }

    public static HisTask newHisTask() {
        return hisTaskSupplier.get();
    }

    public static void setNewIns(Supplier<Instance> supplier) {
        insSupplier = supplier;
    }

    public static Instance newIns() {
        return insSupplier.get();
    }

    public static void setNewNode(Supplier<Node> supplier) {
        nodeSupplier = supplier;
    }

    public static Node newNode() {
        return nodeSupplier.get();
    }

    public static void setNewSkip(Supplier<Skip> supplier) {
        skipSupplier = supplier;
    }

    public static Skip newSkip() {
        return skipSupplier.get();
    }

    public static void setNewTask(Supplier<Task> supplier) {
        taskSupplier = supplier;
    }

    public static Task newTask() {
        return taskSupplier.get();
    }

    public static void setNewUser(Supplier<User> supplier) {
        userSupplier = supplier;
    }

    public static User newUser() {
        return userSupplier.get();
    }

    public static WarmFlow getFlowConfig() {
        return flowConfig;
    }

    public static void setFlowConfig(WarmFlow flowConfig) {
        FlowFactory.flowConfig = flowConfig;
    }

    public static boolean isLogicDelete() {
        return flowConfig.isLogicDelete();
    }

    public static DataFillHandler dataFillHandler() {
        if (ObjectUtil.isNotNull(dataFillHandler)) {
            return dataFillHandler;
        }
        DataFillHandler o = null;
        try {
            Class<?> clazz;
            String dataFillHandlerPath = flowConfig.getDataFillHandlerPath();
            if (!StringUtils.isEmpty(dataFillHandlerPath) && (clazz = ClassUtil.getClazz(dataFillHandlerPath)) != null) {
                dataFillHandler = o = (DataFillHandler)clazz.newInstance();
                return o;
            }
            o = FrameInvoker.getBean(DataFillHandler.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ObjectUtil.isNull(o)) {
            dataFillHandler = new DataFillHandler(){};
            return dataFillHandler;
        }
        dataFillHandler = o;
        return dataFillHandler;
    }

    public static TenantHandler tenantHandler() {
        if (ObjectUtil.isNotNull(tenantHandler) || tenantHandlerFlag) {
            return tenantHandler;
        }
        TenantHandler o = null;
        try {
            Class<?> clazz;
            String tenantHandlerPath = flowConfig.getTenantHandlerPath();
            if (!StringUtils.isEmpty(tenantHandlerPath) && (clazz = ClassUtil.getClazz(tenantHandlerPath)) != null) {
                tenantHandler = o = (TenantHandler)clazz.newInstance();
                return o;
            }
            o = FrameInvoker.getBean(TenantHandler.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        tenantHandlerFlag = true;
        tenantHandler = o;
        return tenantHandler;
    }

    public static void jsonConvert(JsonConvert jsonConvert) {
        FlowFactory.jsonConvert = jsonConvert;
    }

    public static String dataSourceType() {
        return flowConfig.getDataSourceType();
    }
}

