/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import org.dromara.warm.flow.core.chart.FlowChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.utils.DrawUtils;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class BetweenChart
implements FlowChart {
    private int n;
    private int xRect;
    private int yRect;
    private Color c;
    private TextChart textChart;

    public BetweenChart() {
    }

    public BetweenChart(int xRect, int yRect, Color c, TextChart textChart) {
        this.xRect = xRect;
        this.yRect = yRect;
        this.c = c;
        this.textChart = textChart;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public BetweenChart setN(int n) {
        this.n = n;
        return this;
    }

    public int getxRect() {
        return this.xRect;
    }

    public BetweenChart setxRect(int xRect) {
        this.xRect = xRect;
        return this;
    }

    public int getyRect() {
        return this.yRect;
    }

    public BetweenChart setyRect(int yRect) {
        this.yRect = yRect;
        return this;
    }

    public Color getC() {
        return this.c;
    }

    public BetweenChart setC(Color c) {
        this.c = c;
        return this;
    }

    public TextChart getTextChart() {
        return this.textChart;
    }

    public BetweenChart setTextChart(TextChart textChart) {
        this.textChart = textChart;
        return this;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(this.c);
        graphics.drawRoundRect((this.xRect - 50) * this.n, (this.yRect - 40) * this.n, 100 * this.n, 80 * this.n, 20 * this.n, 20 * this.n);
        if (ObjectUtil.isNotNull(this.textChart) && StringUtils.isNotEmpty(this.textChart.getTitle())) {
            this.textChart.setxText(this.textChart.getxText() - DrawUtils.stringWidth(graphics, this.textChart.getTitle()) / 2);
            this.textChart.setN(this.n).draw(graphics);
        }
    }
}

