/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import org.dromara.warm.flow.core.chart.FlowChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.utils.DrawUtils;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class OvalChart
implements FlowChart {
    private int n;
    private int xStartOval;
    private int yStartOval;
    private Color c;
    private TextChart textChart;

    public OvalChart() {
    }

    public OvalChart(int xStartOval, int yStartOval, Color c, TextChart textChart) {
        this.xStartOval = xStartOval;
        this.yStartOval = yStartOval;
        this.c = c;
        this.textChart = textChart;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public OvalChart setN(int n) {
        this.n = n;
        return this;
    }

    public int getxStartOval() {
        return this.xStartOval;
    }

    public OvalChart setxStartOval(int xStartOval) {
        this.xStartOval = xStartOval;
        return this;
    }

    public int getyStartOval() {
        return this.yStartOval;
    }

    public OvalChart setyStartOval(int yStartOval) {
        this.yStartOval = yStartOval;
        return this;
    }

    public Color getC() {
        return this.c;
    }

    public OvalChart setC(Color c) {
        this.c = c;
        return this;
    }

    public TextChart getTextChart() {
        return this.textChart;
    }

    public OvalChart setTextChart(TextChart textChart) {
        this.textChart = textChart;
        return this;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(this.c);
        graphics.drawOval((this.xStartOval - 20) * this.n, (this.yStartOval - 20) * this.n, 40 * this.n, 40 * this.n);
        if (ObjectUtil.isNotNull(this.textChart) && StringUtils.isNotEmpty(this.textChart.getTitle())) {
            this.textChart.setxText(this.textChart.getxText() - DrawUtils.stringWidth(graphics, this.textChart.getTitle()) / 2);
            this.textChart.setyText(this.textChart.getyText() + 5);
            this.textChart.setN(this.n).draw(graphics);
        }
    }
}

