/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import org.dromara.warm.flow.core.chart.FlowChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.utils.DrawUtils;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class SkipChart
implements FlowChart {
    private int n;
    private int[] xPoints;
    private int[] yPoints;
    private Color c;
    private TextChart textChart;

    public SkipChart() {
    }

    public SkipChart(int[] xPoints, int[] yPoints, Color c, TextChart textChart) {
        this.xPoints = xPoints;
        this.yPoints = yPoints;
        this.c = c;
        this.textChart = textChart;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public SkipChart setN(int n) {
        this.n = n;
        return this;
    }

    public int[] getxPoints() {
        return this.xPoints;
    }

    public SkipChart setxPoints(int[] xPoints) {
        this.xPoints = xPoints;
        return this;
    }

    public int[] getyPoints() {
        return this.yPoints;
    }

    public SkipChart setyPoints(int[] yPoints) {
        this.yPoints = yPoints;
        return this;
    }

    public Color getC() {
        return this.c;
    }

    public SkipChart setC(Color c) {
        this.c = c;
        return this;
    }

    public TextChart getTextChart() {
        return this.textChart;
    }

    public SkipChart setTextChart(TextChart textChart) {
        this.textChart = textChart;
        return this;
    }

    @Override
    public void draw(Graphics2D graphics) {
        int[] yArrow;
        int[] xArrow;
        graphics.setColor(this.c);
        this.xPoints = Arrays.stream(this.xPoints).map(x -> x * this.n).toArray();
        this.yPoints = Arrays.stream(this.yPoints).map(y -> y * this.n).toArray();
        graphics.drawPolyline(this.xPoints, this.yPoints, this.xPoints.length);
        int xEndOne = this.xPoints[this.xPoints.length - 1];
        int xEndTwo = this.xPoints[this.xPoints.length - 2];
        int yEndOne = this.yPoints[this.yPoints.length - 1];
        int yEndTwo = this.yPoints[this.yPoints.length - 2];
        int xArrowLength = 5 * this.n;
        int yArrowLength = 10 * this.n;
        if (xEndOne == xEndTwo) {
            xArrow = new int[]{xEndOne - xArrowLength, xEndOne, xEndOne + xArrowLength};
            yArrow = yEndOne > yEndTwo ? new int[]{yEndOne - yArrowLength, yEndOne, yEndOne - yArrowLength} : new int[]{yEndOne + yArrowLength, yEndOne, yEndOne + yArrowLength};
        } else {
            yArrow = new int[]{yEndOne - xArrowLength, yEndOne, yEndOne + xArrowLength};
            xArrow = xEndOne < xEndTwo ? new int[]{xEndOne + yArrowLength, xEndOne, xEndOne + yArrowLength} : new int[]{xEndOne - yArrowLength, xEndOne, xEndOne - yArrowLength};
        }
        graphics.fillPolygon(xArrow, yArrow, 3);
        if (ObjectUtil.isNotNull(this.textChart) && StringUtils.isNotEmpty(this.textChart.getTitle())) {
            this.textChart.setxText(this.textChart.getxText() - DrawUtils.stringWidth(graphics, this.textChart.getTitle()) / 2);
            this.textChart.setyText(this.textChart.getyText() - 10);
            this.textChart.setN(this.n).draw(graphics);
        }
    }
}

