/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.enums;

import java.math.BigDecimal;
import java.util.Objects;

public enum CooperateType {
    APPROVAL(1, "\u65e0"),
    TRANSFER(2, "\u8f6c\u529e"),
    DEPUTE(3, "\u59d4\u6d3e"),
    COUNTERSIGN(4, "\u4f1a\u7b7e"),
    VOTE(5, "\u7968\u7b7e"),
    ADD_SIGNATURE(6, "\u52a0\u7b7e"),
    REDUCTION_SIGNATURE(7, "\u51cf\u7b7e");

    private Integer key;
    private String value;
    public static final BigDecimal ONE_HUNDRED;

    private CooperateType(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public static Integer getKeyByValue(String value) {
        for (CooperateType item : CooperateType.values()) {
            if (!item.getValue().equals(value)) continue;
            return item.getKey();
        }
        return null;
    }

    public static String getValueByKey(Integer key) {
        for (CooperateType item : CooperateType.values()) {
            if (!item.getKey().equals(key)) continue;
            return item.getValue();
        }
        return null;
    }

    public static CooperateType getByKey(Integer key) {
        for (CooperateType item : CooperateType.values()) {
            if (!item.getKey().equals(key)) continue;
            return item;
        }
        return null;
    }

    public Integer getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isOrSign(BigDecimal ratio) {
        return Objects.isNull(ratio) || ratio.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isVoteSign(BigDecimal ratio) {
        return Objects.nonNull(ratio) && ratio.compareTo(BigDecimal.ZERO) > 0 && ratio.compareTo(ONE_HUNDRED) < 0;
    }

    public static boolean isCountersign(BigDecimal ratio) {
        return Objects.nonNull(ratio) && ratio.compareTo(ONE_HUNDRED) >= 0;
    }

    static {
        ONE_HUNDRED = BigDecimal.valueOf(100L);
    }
}

