/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.enums;

import org.dromara.warm.flow.core.utils.ObjectUtil;

public enum NodeType {
    START(0, "start"),
    BETWEEN(1, "between"),
    END(2, "end"),
    SERIAL(3, "serial"),
    PARALLEL(4, "parallel");

    private Integer key;
    private String value;

    private NodeType(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public static Integer getKeyByValue(String value) {
        for (NodeType item : NodeType.values()) {
            if (!item.getValue().equals(value)) continue;
            return item.getKey();
        }
        return null;
    }

    public static String getValueByKey(Integer Key2) {
        for (NodeType item : NodeType.values()) {
            if (!item.getKey().equals(Key2)) continue;
            return item.getValue();
        }
        return null;
    }

    public static NodeType getByKey(String key) {
        for (NodeType item : NodeType.values()) {
            if (!item.getKey().equals(key)) continue;
            return item;
        }
        return null;
    }

    public static Boolean isStart(Integer Key2) {
        return ObjectUtil.isNotNull(Key2) && START.getKey().equals(Key2);
    }

    public static Boolean isBetween(Integer Key2) {
        return ObjectUtil.isNotNull(Key2) && BETWEEN.getKey().equals(Key2);
    }

    public static Boolean isEnd(Integer Key2) {
        return ObjectUtil.isNotNull(Key2) && END.getKey().equals(Key2);
    }

    public static Boolean isGateWay(Integer Key2) {
        return ObjectUtil.isNotNull(Key2) && (SERIAL.getKey().equals(Key2) || PARALLEL.getKey().equals(Key2));
    }

    public static Boolean isGateWaySerial(Integer Key2) {
        return ObjectUtil.isNotNull(Key2) && SERIAL.getKey().equals(Key2);
    }

    public static Boolean isGateWayParallel(Integer Key2) {
        return ObjectUtil.isNotNull(Key2) && PARALLEL.getKey().equals(Key2);
    }

    public Integer getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

