/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.keygen;

import org.dromara.warm.flow.core.keygen.KenGen;

public class SnowFlakeId15
implements KenGen {
    private final long epoch = 1609459200000L;
    private final long sequenceBits = 6L;
    private final long machineIdBits = 4L;
    private final long maxMachineId = 15L;
    private final long maxSequence = 63L;
    private final long sequenceShift = 0L;
    private final long machineIdShift = 6L;
    private final long timestampShift = 10L;
    private long machineId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowFlakeId15(long machineId) {
        if (machineId > 15L || machineId < 0L) {
            throw new IllegalArgumentException("Machine ID is out of bounds.");
        }
        this.machineId = machineId;
    }

    @Override
    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate id.");
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0x3FL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long id = timestamp - 1609459200000L << 10 | this.machineId << 6 | this.sequence;
        return id % 10000000000000000L;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

