/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.listener;

import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.listener.NodePermission;

public class ListenerVariable {
    private Definition definition;
    private Instance instance;
    private Node node;
    private Task task;
    private List<Node> nextNodes;
    private List<Task> nextTasks;
    private Map<String, Object> variable;
    private FlowParams flowParams;
    @Deprecated
    private List<NodePermission> nodePermissionList;

    public ListenerVariable() {
    }

    public ListenerVariable(Definition definition, Instance instance, Map<String, Object> variable) {
        this.definition = definition;
        this.instance = instance;
        this.variable = variable;
    }

    public ListenerVariable(Definition definition, Instance instance, Node node, Map<String, Object> variable) {
        this.definition = definition;
        this.instance = instance;
        this.node = node;
        this.variable = variable;
    }

    public ListenerVariable(Definition definition, Instance instance, Map<String, Object> variable, Task task) {
        this.definition = definition;
        this.instance = instance;
        this.variable = variable;
        this.task = task;
    }

    public ListenerVariable(Definition definition, Instance instance, Node node, Map<String, Object> variable, Task task) {
        this.definition = definition;
        this.instance = instance;
        this.node = node;
        this.variable = variable;
        this.task = task;
    }

    public ListenerVariable(Definition definition, Instance instance, Node node, Map<String, Object> variable, Task task, List<Node> nextNodes) {
        this.definition = definition;
        this.instance = instance;
        this.node = node;
        this.variable = variable;
        this.task = task;
        this.nextNodes = nextNodes;
    }

    public ListenerVariable(Definition definition, Instance instance, Node node, Map<String, Object> variable, Task task, List<Node> nextNodes, List<Task> nextTasks) {
        this.definition = definition;
        this.instance = instance;
        this.node = node;
        this.variable = variable;
        this.task = task;
        this.nextNodes = nextNodes;
        this.nextTasks = nextTasks;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public ListenerVariable setDefinition(Definition definition) {
        this.definition = definition;
        return this;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public ListenerVariable setInstance(Instance instance) {
        this.instance = instance;
        return this;
    }

    public Node getNode() {
        return this.node;
    }

    public ListenerVariable setNode(Node node) {
        this.node = node;
        return this;
    }

    public Task getTask() {
        return this.task;
    }

    public ListenerVariable setTask(Task task) {
        this.task = task;
        return this;
    }

    public List<Node> getNextNodes() {
        return this.nextNodes;
    }

    public ListenerVariable setNextNodes(List<Node> nextNodes) {
        this.nextNodes = nextNodes;
        return this;
    }

    public List<Task> getNextTasks() {
        return this.nextTasks;
    }

    public ListenerVariable setNextTasks(List<Task> nextTasks) {
        this.nextTasks = nextTasks;
        return this;
    }

    public Map<String, Object> getVariable() {
        return this.variable;
    }

    public ListenerVariable setVariable(Map<String, Object> variable) {
        this.variable = variable;
        return this;
    }

    public List<NodePermission> getNodePermissionList() {
        return this.nodePermissionList;
    }

    public void setNodePermissionList(List<NodePermission> nodePermissionList) {
        this.nodePermissionList = nodePermissionList;
    }

    public NodePermission getPermissionByNode(String nodeCode) {
        return this.nodePermissionList.stream().filter(t -> t.getNodeCode().equals(nodeCode)).findFirst().orElse(null);
    }

    public FlowParams getFlowParams() {
        return this.flowParams;
    }

    public ListenerVariable setFlowParams(FlowParams flowParams) {
        this.flowParams = flowParams;
        return this;
    }

    public String toString() {
        return "ListenerVariable{definition=" + this.definition + ", instance=" + this.instance + ", node=" + this.node + ", task=" + this.task + ", nextNodes=" + this.nextNodes + ", nextTasks=" + this.nextTasks + ", variable=" + this.variable + ", flowParams=" + this.flowParams + ", nodePermissionList=" + this.nodePermissionList + '}';
    }
}

