/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.dom4j.Document;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.chart.BetweenChart;
import org.dromara.warm.flow.core.chart.FlowChart;
import org.dromara.warm.flow.core.chart.FlowChartChain;
import org.dromara.warm.flow.core.chart.OvalChart;
import org.dromara.warm.flow.core.chart.ParallelChart;
import org.dromara.warm.flow.core.chart.SerialChart;
import org.dromara.warm.flow.core.chart.SkipChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.dao.FlowDefinitionDao;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.enums.ActivityStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.PublishStatus;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.DefService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.Base64;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.FlowConfigUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefServiceImpl
extends WarmServiceImpl<FlowDefinitionDao<Definition>, Definition>
implements DefService {
    private static final Logger log = LoggerFactory.getLogger(DefServiceImpl.class);

    public DefService setDao(FlowDefinitionDao<Definition> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public Definition importXml(InputStream is) throws Exception {
        if (ObjectUtil.isNull(is)) {
            return null;
        }
        FlowCombine combine = FlowConfigUtil.readConfig(is);
        Definition definition = combine.getDefinition();
        List<Node> allNodes = combine.getAllNodes();
        List<Skip> allSkips = combine.getAllSkips();
        this.insertFlow(definition, allNodes, allSkips);
        return definition;
    }

    @Override
    public void saveXml(Definition def) throws Exception {
        this.saveXml(def.getId(), def.getXmlString());
    }

    @Override
    public void saveXml(Long id, String xmlString) throws Exception {
        if (ObjectUtil.isNull(id) || StringUtils.isEmpty(xmlString)) {
            return;
        }
        FlowCombine combine = FlowConfigUtil.readConfig(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
        List<Node> allNodes = combine.getAllNodes();
        List<Skip> allSkips = combine.getAllSkips();
        FlowFactory.nodeService().remove(FlowFactory.newNode().setDefinitionId(id));
        FlowFactory.skipService().remove(FlowFactory.newSkip().setDefinitionId(id));
        allNodes.forEach(node -> node.setDefinitionId(id));
        allSkips.forEach(skip -> skip.setDefinitionId(id));
        FlowFactory.nodeService().saveBatch(allNodes);
        FlowFactory.skipService().saveBatch(allSkips);
    }

    @Override
    public Document exportXml(Long id) {
        Definition definition = this.getAllDataDefinition(id);
        return FlowConfigUtil.createDocument(definition);
    }

    @Override
    public String xmlString(Long id) {
        Definition definition = this.getAllDataDefinition(id);
        Document document = FlowConfigUtil.createDocument(definition);
        return document.asXML();
    }

    @Override
    public List<Definition> queryByCodeList(List<String> flowCodeList) {
        return ((FlowDefinitionDao)this.getDao()).queryByCodeList(flowCodeList);
    }

    @Override
    public void closeFlowByCodeList(List<String> flowCodeList) {
        ((FlowDefinitionDao)this.getDao()).closeFlowByCodeList(flowCodeList);
    }

    @Override
    public boolean checkAndSave(Definition definition) {
        String version = this.getNewVersion(definition);
        definition.setVersion(version);
        return this.save(definition);
    }

    @Override
    public boolean removeDef(List<Long> ids) {
        FlowFactory.nodeService().deleteNodeByDefIds(ids);
        FlowFactory.skipService().deleteSkipByDefIds(ids);
        return this.removeByIds(ids);
    }

    @Override
    public boolean publish(Long id) {
        Definition definition = (Definition)this.getById(id);
        List<String> flowCodeList = Collections.singletonList(definition.getFlowCode());
        this.closeFlowByCodeList(flowCodeList);
        Definition flowDefinition = FlowFactory.newDef();
        flowDefinition.setId(id);
        flowDefinition.setIsPublish(PublishStatus.PUBLISHED.getKey());
        return this.updateById(flowDefinition);
    }

    @Override
    public boolean unPublish(Long id) {
        List<Task> tasks = FlowFactory.taskService().list(FlowFactory.newTask().setDefinitionId(id));
        AssertUtil.isNotEmpty(tasks, "\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5f85\u529e\u4efb\u52a1\uff0c\u4e0d\u53ef\u53d6\u6d88!");
        Definition definition = FlowFactory.newDef().setId(id);
        definition.setIsPublish(PublishStatus.UNPUBLISHED.getKey());
        return this.updateById(definition);
    }

    @Override
    public boolean copyDef(Long id) {
        Definition definition = ((Definition)this.getById(id)).copy();
        AssertUtil.isNull(definition, "\u6d41\u7a0b\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728!");
        List<Node> nodeList = FlowFactory.nodeService().list(FlowFactory.newNode().setDefinitionId(id)).stream().map(Node::copy).collect(Collectors.toList());
        List<Skip> skipList = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(id)).stream().map(Skip::copy).collect(Collectors.toList());
        FlowFactory.dataFillHandler().idFill(definition.setId(null));
        definition.setVersion(definition.getVersion() + "_copy").setIsPublish(PublishStatus.UNPUBLISHED.getKey()).setCreateTime(null).setUpdateTime(null);
        nodeList.forEach(node -> node.setId(null).setDefinitionId(definition.getId()).setVersion(definition.getVersion()).setCreateTime(null).setUpdateTime(null));
        FlowFactory.nodeService().saveBatch(nodeList);
        skipList.forEach(skip -> skip.setId(null).setDefinitionId(definition.getId()).setCreateTime(null).setUpdateTime(null));
        FlowFactory.skipService().saveBatch(skipList);
        return this.save(definition);
    }

    @Override
    public boolean active(Long id) {
        Definition definition = (Definition)this.getById(id);
        AssertUtil.isTrue(definition.getActivityStatus().equals(ActivityStatus.ACTIVITY.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u5df2\u7ecf\u6fc0\u6d3b");
        definition.setActivityStatus(ActivityStatus.ACTIVITY.getKey());
        return this.updateById(definition);
    }

    @Override
    public boolean unActive(Long id) {
        Definition definition = (Definition)this.getById(id);
        AssertUtil.isTrue(definition.getActivityStatus().equals(ActivityStatus.SUSPENDED.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u5df2\u7ecf\u6302\u8d77");
        definition.setActivityStatus(ActivityStatus.SUSPENDED.getKey());
        return this.updateById(definition);
    }

    @Override
    public String flowChart(Long instanceId) {
        Long definitionId = ((Instance)FlowFactory.insService().getById(instanceId)).getDefinitionId();
        return this.basicFlowChart(instanceId, definitionId);
    }

    @Override
    public List<FlowChart> flowChartData(Long instanceId) {
        Long definitionId = ((Instance)FlowFactory.insService().getById(instanceId)).getDefinitionId();
        FlowChartChain flowChartChain = new FlowChartChain();
        this.basicFlowChart(instanceId, definitionId, flowChartChain);
        return flowChartChain.getFlowChartList();
    }

    @Override
    public String flowChartNoColor(Long definitionId) {
        return this.basicFlowChart(null, definitionId);
    }

    @Override
    public List<FlowChart> flowChartNoColorData(Long definitionId) {
        FlowChartChain flowChartChain = new FlowChartChain();
        this.basicFlowChart(null, definitionId, flowChartChain);
        return flowChartChain.getFlowChartList();
    }

    public String basicFlowChart(Long instanceId, Long definitionId) {
        try {
            FlowChartChain flowChartChain = new FlowChartChain();
            Map<String, Integer> nodeXY = this.basicFlowChart(instanceId, definitionId, flowChartChain);
            int n = 2;
            int width = (nodeXY.get("maxX") + nodeXY.get("minX")) * n;
            int height = (nodeXY.get("maxY") + nodeXY.get("minY")) * n;
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D graphics = image.createGraphics();
            graphics.setStroke(new BasicStroke(2 * n + 1, 2, 1));
            Font font = new Font("\u5b8b\u4f53", 1, 12 * n);
            graphics.setFont(font);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, width, height);
            flowChartChain.draw(graphics, n);
            graphics.setPaintMode();
            graphics.dispose();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            return Base64.encode(os.toByteArray());
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6d41\u7a0b\u56fe\u5f02\u5e38", (Throwable)e);
            throw new FlowException("\u83b7\u53d6\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
    }

    public Map<String, Integer> basicFlowChart(Long instanceId, Long definitionId, FlowChartChain flowChartChain) {
        Instance instance = ObjectUtil.isNotNull(instanceId) ? (Instance)FlowFactory.insService().getById(instanceId) : null;
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        Map<String, Integer> nodeXY = this.addNodeChart(colorMap, instance, definitionId, flowChartChain);
        this.addSkipChart(colorMap, instance, definitionId, flowChartChain);
        return nodeXY;
    }

    private void addSkipChart(Map<String, Color> colorMap, Instance instance, Long definitionId, FlowChartChain flowChartChain) {
        List<Skip> skipList = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(definitionId));
        for (Skip skip : skipList) {
            if (!StringUtils.isNotEmpty(skip.getCoordinate())) continue;
            String[] coordinateSplit = skip.getCoordinate().split("\\|");
            String[] skipSplit = coordinateSplit[0].split(";");
            int[] skipX = new int[skipSplit.length];
            int[] skipY = new int[skipSplit.length];
            TextChart textChart = null;
            if (coordinateSplit.length > 1) {
                String[] textSplit = coordinateSplit[1].split(",");
                int textX = Integer.parseInt(textSplit[0].split("\\.")[0]);
                int textY = Integer.parseInt(textSplit[1].split("\\.")[0]);
                textChart = new TextChart(textX, textY, skip.getSkipName());
            }
            for (int i = 0; i < skipSplit.length; ++i) {
                skipX[i] = Integer.parseInt(skipSplit[i].split(",")[0].split("\\.")[0]);
                skipY[i] = Integer.parseInt(skipSplit[i].split(",")[1].split("\\.")[0]);
            }
            Color c = ObjectUtil.isNotNull(instance) ? this.colorGet(colorMap, "skip:" + skip.getId().toString()) : Color.BLACK;
            flowChartChain.addFlowChart(new SkipChart(skipX, skipY, c, textChart));
        }
    }

    private Map<String, Integer> addNodeChart(Map<String, Color> colorMap, Instance instance, Long definitionId, FlowChartChain flowChartChain) {
        List<Node> nodeList = FlowFactory.nodeService().list(FlowFactory.newNode().setDefinitionId(definitionId));
        List<Skip> allSkips = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(definitionId).setSkipType(SkipType.PASS.getKey()));
        if (ObjectUtil.isNotNull(instance)) {
            List<Node> needChartNodes = this.filterNodes(instance, allSkips, nodeList);
            this.setColorMap(colorMap, instance, allSkips, needChartNodes);
        }
        HashMap<String, Integer> maxR = new HashMap<String, Integer>();
        maxR.put("minX", 5000);
        maxR.put("minY", 5000);
        maxR.put("maxX", 0);
        maxR.put("maxY", 0);
        for (Node node : nodeList) {
            if (!StringUtils.isNotEmpty(node.getCoordinate())) continue;
            String[] coordinateSplit = node.getCoordinate().split("\\|");
            String[] nodeSplit = coordinateSplit[0].split(",");
            int nodeX = Integer.parseInt(nodeSplit[0].split("\\.")[0]);
            int nodeY = Integer.parseInt(nodeSplit[1].split("\\.")[0]);
            if (nodeX > (Integer)maxR.get("maxX")) {
                maxR.put("maxX", nodeX);
            }
            if (nodeX < (Integer)maxR.get("minX")) {
                maxR.put("minX", nodeX);
            }
            if (nodeY > (Integer)maxR.get("maxY")) {
                maxR.put("maxY", nodeY);
            }
            if (nodeY < (Integer)maxR.get("minY")) {
                maxR.put("minY", nodeY);
            }
            TextChart textChart = null;
            if (coordinateSplit.length > 1) {
                String[] textSplit = coordinateSplit[1].split(",");
                int textX = Integer.parseInt(textSplit[0].split("\\.")[0]);
                int textY = Integer.parseInt(textSplit[1].split("\\.")[0]);
                textChart = new TextChart(textX, textY, node.getNodeName());
            }
            Color c = ObjectUtil.isNotNull(instance) ? this.colorGet(colorMap, "node:" + node.getNodeCode()) : Color.BLACK;
            if (NodeType.isStart(node.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new OvalChart(nodeX, nodeY, ObjectUtil.isNotNull(instance) ? Color.GREEN : Color.BLACK, textChart));
                continue;
            }
            if (NodeType.isBetween(node.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new BetweenChart(nodeX, nodeY, c, textChart));
                continue;
            }
            if (NodeType.isGateWaySerial(node.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new SerialChart(nodeX, nodeY, c));
                continue;
            }
            if (NodeType.isGateWayParallel(node.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new ParallelChart(nodeX, nodeY, c));
                continue;
            }
            if (!NodeType.isEnd(node.getNodeType()).booleanValue()) continue;
            flowChartChain.addFlowChart(new OvalChart(nodeX, nodeY, c, textChart));
        }
        return maxR;
    }

    private List<Node> filterNodes(Instance instance, List<Skip> allSkips, List<Node> nodeList) {
        ArrayList<String> allNextNode = new ArrayList<String>();
        Map<String, List<Skip>> skipNextMap = StreamUtils.groupByKey(allSkips, Skip::getNowNodeCode);
        if (NodeType.isEnd(instance.getNodeType()).booleanValue()) {
            return nodeList;
        }
        List<Task> curTasks = FlowFactory.taskService().list(FlowFactory.newTask().setInstanceId(instance.getId()));
        for (Task curTask : curTasks) {
            List<Skip> nextSkips = skipNextMap.get(curTask.getNodeCode());
            this.getAllNextNode(nextSkips, allNextNode, skipNextMap);
        }
        return StreamUtils.filter(nodeList, node -> !allNextNode.contains(node.getNodeCode()));
    }

    private void getAllNextNode(List<Skip> nextSkips, List<String> allNextNode, Map<String, List<Skip>> skipMap) {
        if (CollUtil.isNotEmpty(nextSkips)) {
            for (Skip nextSkip : nextSkips) {
                allNextNode.add(nextSkip.getNextNodeCode());
                List<Skip> nextNextSkips = skipMap.get(nextSkip.getNextNodeCode());
                this.getAllNextNode(nextNextSkips, allNextNode, skipMap);
            }
        }
    }

    public void setColorMap(Map<String, Color> colorMap, Instance instance, List<Skip> allSkips, List<Node> nodeList) {
        Color color = Color.PINK;
        Map<String, List<Skip>> skipLastMap = StreamUtils.groupByKey(allSkips, Skip::getNextNodeCode);
        Map<String, List<Skip>> skipNextMap = StreamUtils.groupByKey(allSkips, Skip::getNowNodeCode);
        List<HisTask> hisTaskList = FlowFactory.hisTaskService().getNoReject(instance.getId());
        for (Node node : nodeList) {
            List<Skip> oneNextSkips = skipNextMap.get(node.getNodeCode());
            List<Skip> oneLastSkips = skipLastMap.get(node.getNodeCode());
            if (NodeType.isStart(node.getNodeType()).booleanValue()) {
                this.colorPut(colorMap, "node:" + node.getNodeCode(), Color.GREEN);
                if (!CollUtil.isNotEmpty(oneNextSkips)) continue;
                oneNextSkips.forEach(oneNextSkip -> this.colorPut(colorMap, "skip:" + oneNextSkip.getId().toString(), Color.GREEN));
                continue;
            }
            if (NodeType.isGateWay(node.getNodeType()).booleanValue()) continue;
            Task task = FlowFactory.taskService().getOne(FlowFactory.newTask().setNodeCode(node.getNodeCode()).setInstanceId(instance.getId()));
            HisTask curHisTask = FlowFactory.hisTaskService().getNoReject(node.getNodeCode(), null, hisTaskList);
            if (!CollUtil.isNotEmpty(oneLastSkips)) continue;
            for (Skip oneLastSkip : oneLastSkips) {
                Color c = null;
                if (NodeType.isStart(oneLastSkip.getNowNodeType()).booleanValue() && task == null) {
                    this.colorPut(colorMap, "node:" + node.getNodeCode(), Color.GREEN);
                    this.setNextColorMap(colorMap, oneNextSkips, Color.GREEN);
                    continue;
                }
                if (NodeType.isGateWay(oneLastSkip.getNowNodeType()).booleanValue()) {
                    List<Skip> twoLastSkips = skipLastMap.get(oneLastSkip.getNowNodeCode());
                    for (Skip twoLastSkip : twoLastSkips) {
                        HisTask twoLastHisTask = FlowFactory.hisTaskService().getNoReject(twoLastSkip.getNowNodeCode(), node.getNodeCode(), hisTaskList);
                        if (task != null) {
                            c = color;
                            if (ObjectUtil.isNotNull(twoLastHisTask)) {
                                this.colorPut(colorMap, "skip:" + oneLastSkip.getId().toString(), Color.GREEN);
                                this.colorPut(colorMap, "node:" + oneLastSkip.getNowNodeCode(), Color.GREEN);
                            }
                        } else {
                            if (NodeType.isEnd(node.getNodeType()).booleanValue() && NodeType.isEnd(instance.getNodeType()).booleanValue()) {
                                HisTask curHisTaskN = FlowFactory.hisTaskService().getNoReject(null, node.getNodeCode(), hisTaskList);
                                if (ObjectUtil.isNotNull(curHisTaskN)) {
                                    c = Color.GREEN;
                                    curHisTaskN = FlowFactory.hisTaskService().getNoReject(twoLastSkip.getNowNodeCode(), node.getNodeCode(), hisTaskList);
                                    if (ObjectUtil.isNotNull(curHisTaskN)) {
                                        this.colorPut(colorMap, "skip:" + oneLastSkip.getId().toString(), c);
                                        this.colorPut(colorMap, "node:" + oneLastSkip.getNowNodeCode(), c);
                                    }
                                }
                            } else if (curHisTask != null && ObjectUtil.isNotNull(twoLastHisTask) && (twoLastHisTask.getUpdateTime().before(curHisTask.getUpdateTime()) || twoLastHisTask.getUpdateTime().equals(curHisTask.getUpdateTime()))) {
                                c = Color.GREEN;
                                this.colorPut(colorMap, "node:" + oneLastSkip.getNowNodeCode(), c);
                            } else {
                                c = Color.BLACK;
                            }
                            if (ObjectUtil.isNotNull(twoLastHisTask)) {
                                this.colorPut(colorMap, "skip:" + oneLastSkip.getId().toString(), c);
                            }
                        }
                        this.colorPut(colorMap, "node:" + node.getNodeCode(), c);
                        this.setNextColorMap(colorMap, oneNextSkips, c);
                    }
                    continue;
                }
                if (NodeType.isEnd(node.getNodeType()).booleanValue() && NodeType.isEnd(instance.getNodeType()).booleanValue()) {
                    HisTask curHisTaskN = FlowFactory.hisTaskService().getNoReject(null, node.getNodeCode(), hisTaskList);
                    if (!ObjectUtil.isNotNull(curHisTaskN)) continue;
                    this.colorPut(colorMap, "node:" + node.getNodeCode(), Color.GREEN);
                    curHisTaskN = FlowFactory.hisTaskService().getNoReject(oneLastSkip.getNowNodeCode(), node.getNodeCode(), hisTaskList);
                    if (!ObjectUtil.isNotNull(curHisTaskN)) continue;
                    this.colorPut(colorMap, "skip:" + oneLastSkip.getId().toString(), Color.GREEN);
                    continue;
                }
                HisTask oneLastHisTask = FlowFactory.hisTaskService().getNoReject(oneLastSkip.getNowNodeCode(), node.getNodeCode(), hisTaskList);
                c = task != null ? color : (curHisTask != null && ObjectUtil.isNotNull(oneLastHisTask) && (oneLastHisTask.getUpdateTime().before(curHisTask.getUpdateTime()) || oneLastHisTask.getUpdateTime().equals(curHisTask.getUpdateTime())) ? Color.GREEN : Color.BLACK);
                if (ObjectUtil.isNotNull(oneLastHisTask)) {
                    this.colorPut(colorMap, "skip:" + oneLastSkip.getId().toString(), c);
                }
                this.colorPut(colorMap, "node:" + node.getNodeCode(), c);
                this.setNextColorMap(colorMap, oneNextSkips, c);
            }
        }
    }

    private void setNextColorMap(Map<String, Color> colorMap, List<Skip> oneNextSkips, Color c) {
        if (CollUtil.isNotEmpty(oneNextSkips)) {
            oneNextSkips.forEach(oneNextSkip -> {
                this.colorPut(colorMap, "skip:" + oneNextSkip.getId().toString(), c);
                if (NodeType.isGateWay(oneNextSkip.getNextNodeType()).booleanValue() && (c == Color.GREEN || c == Color.BLACK)) {
                    this.colorPut(colorMap, "node:" + oneNextSkip.getNextNodeCode(), c);
                }
            });
        }
    }

    private void colorPut(Map<String, Color> colorMap, String key, Color c) {
        Color color = colorMap.get(key);
        if (c == Color.GREEN) {
            colorMap.put(key, c);
        } else if (color == null || color == Color.BLACK) {
            colorMap.put(key, c);
        }
    }

    private Color colorGet(Map<String, Color> colorMap, String key) {
        Color color = colorMap.get(key);
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Definition getAllDataDefinition(Long id) {
        Definition definition = (Definition)((FlowDefinitionDao)this.getDao()).selectById(id);
        List<Node> nodeList = FlowFactory.nodeService().list(FlowFactory.newNode().setDefinitionId(id));
        definition.setNodeList(nodeList);
        List<Skip> skips = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(id));
        Map<String, List<Skip>> flowSkipMap = skips.stream().collect(Collectors.groupingBy(Skip::getNowNodeCode));
        nodeList.forEach(flowNode -> flowNode.setSkipList((List)flowSkipMap.get(flowNode.getNodeCode())));
        return definition;
    }

    private void insertFlow(Definition definition, List<Node> allNodes, List<Skip> allSkips) {
        String version = this.getNewVersion(definition);
        definition.setVersion(version);
        for (Node node : allNodes) {
            node.setVersion(version);
        }
        FlowFactory.defService().save(definition);
        FlowFactory.nodeService().saveBatch(allNodes);
        FlowFactory.skipService().saveBatch(allSkips);
    }

    private String getNewVersion(Definition definition) {
        List<String> flowCodeList = Collections.singletonList(definition.getFlowCode());
        List definitions = ((FlowDefinitionDao)this.getDao()).queryByCodeList(flowCodeList);
        int highestVersion = 0;
        String latestNonPositiveVersion = null;
        long latestTimestamp = Long.MIN_VALUE;
        for (Definition otherDef : definitions) {
            if (definition.getVersion() != null && definition.getFlowCode().equals(otherDef.getFlowCode()) && definition.getVersion().equals(otherDef.getVersion())) {
                throw new FlowException(definition.getFlowCode() + "(" + definition.getVersion() + ")" + "\u6d41\u7a0b\u5df2\u7ecf\u5b58\u5728,\u8bf7\u901a\u8fc7\u521b\u5efa\u65b0\u7248\u672c\u7684\u6d41\u7a0b\u5bf9\u8be5\u6d41\u7a0b\u8fdb\u884c\u66f4\u65b0!");
            }
            if (!definition.getFlowCode().equals(otherDef.getFlowCode())) continue;
            try {
                int version = Integer.parseInt(otherDef.getVersion());
                if (version <= highestVersion) continue;
                highestVersion = version;
            }
            catch (NumberFormatException e) {
                long timestamp = otherDef.getCreateTime().getTime();
                if (timestamp <= latestTimestamp) continue;
                latestTimestamp = timestamp;
                latestNonPositiveVersion = otherDef.getVersion();
            }
        }
        String version = definition.getVersion();
        if (version == null || version.isEmpty()) {
            version = highestVersion > 0 ? String.valueOf(highestVersion + 1) : (latestNonPositiveVersion != null ? latestNonPositiveVersion + "_1" : "1");
        }
        return version;
    }
}

