/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.dao.FlowInstanceDao;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.enums.ActivityStatus;
import org.dromara.warm.flow.core.enums.FlowStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.listener.ListenerVariable;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.InsService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ListenerUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.core.utils.VariableUtil;

public class InsServiceImpl
extends WarmServiceImpl<FlowInstanceDao<Instance>, Instance>
implements InsService {
    public InsService setDao(FlowInstanceDao<Instance> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public Instance start(String businessId, FlowParams flowParams) {
        AssertUtil.isNull(flowParams.getFlowCode(), "\u6d41\u7a0b\u7f16\u7801\u7f3a\u5931!");
        AssertUtil.isEmpty(businessId, "\u4e1a\u52a1id\u4e3a\u7a7a!");
        List<Node> nodes = FlowFactory.nodeService().getByFlowCode(flowParams.getFlowCode());
        AssertUtil.isEmpty(nodes, String.format("\u6b64\u6d41\u7a0b\u7f16\u7801[%s]\u7684\u6d41\u7a0b\u8282\u70b9\u672a\u53d1\u5e03!", flowParams.getFlowCode()));
        Node startNode = nodes.stream().filter(t -> NodeType.isStart(t.getNodeType())).findFirst().orElse(null);
        AssertUtil.isNull(startNode, "\u6d41\u7a0b\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9!");
        List<Node> nextNodes = FlowFactory.nodeService().getNextByCheckGateway(flowParams.getVariable(), this.getFirstBetween(startNode));
        Definition definition = (Definition)FlowFactory.defService().getById(nextNodes.get(0).getDefinitionId());
        AssertUtil.isTrue(definition.getActivityStatus().equals(ActivityStatus.SUSPENDED.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u5df2\u6302\u8d77\uff0c\u4e0d\u53ef\u5f00\u542f\u65b0\u7684\u6d41\u7a0b");
        ListenerUtil.executeListener(new ListenerVariable(definition, null, startNode, flowParams.getVariable()).setFlowParams(flowParams), "start");
        Instance instance = this.setStartInstance(nextNodes.get(0), businessId, flowParams);
        ListenerUtil.executeGetNodePermission(new ListenerVariable(definition, instance, startNode, flowParams.getVariable(), null, nextNodes).setFlowParams(flowParams));
        List<HisTask> hisTasks = this.setHisTask(nextNodes, flowParams, startNode, instance.getId());
        List<Task> addTasks = StreamUtils.toList(nextNodes, node -> FlowFactory.taskService().addTask((Node)node, instance, definition, flowParams));
        if (CollUtil.isNotEmpty(addTasks)) {
            addTasks.forEach(addTask -> addTask.getPermissionList().replaceAll(s -> VariableUtil.eval(s, flowParams.getVariable())));
        }
        ListenerUtil.executeListener(new ListenerVariable(definition, instance, startNode, flowParams.getVariable(), null, nextNodes, addTasks).setFlowParams(flowParams), "assignment");
        this.saveFlowInfo(instance, addTasks, hisTasks);
        ListenerUtil.endCreateListener(new ListenerVariable(definition, instance, startNode, flowParams.getVariable(), null, nextNodes, addTasks).setFlowParams(flowParams));
        return instance;
    }

    @Override
    public Instance skipByInsId(Long instanceId, FlowParams flowParams) {
        AssertUtil.isTrue(StringUtils.isNotEmpty(flowParams.getMessage()) && flowParams.getMessage().length() > 500, "\u610f\u89c1\u957f\u5ea6\u8fc7\u957f!");
        List<Task> taskList = FlowFactory.taskService().list(FlowFactory.newTask().setInstanceId(instanceId));
        AssertUtil.isEmpty(taskList, "\u5f85\u529e\u4efb\u52a1\u83b7\u53d6\u5931\u8d25!");
        AssertUtil.isTrue(taskList.size() > 1, "\u6b64\u63a5\u53e3\u4e0d\u80fd\u540c\u65f6\u8df3\u8f6c\u591a\u4e2a\u5f85\u529e\u4efb\u52a1\uff0c\u8bf7\u66f4\u6362!");
        Task task = taskList.get(0);
        return FlowFactory.taskService().skip(flowParams, task);
    }

    @Override
    public Instance termination(Long instanceId, FlowParams flowParams) {
        List<Task> taskList = FlowFactory.taskService().list(FlowFactory.newTask().setInstanceId(instanceId));
        AssertUtil.isEmpty(taskList, "\u5f85\u529e\u4efb\u52a1\u83b7\u53d6\u5931\u8d25!");
        Task task = taskList.get(0);
        return FlowFactory.taskService().termination(task, flowParams);
    }

    @Override
    public boolean remove(List<Long> instanceIds) {
        return this.toRemoveTask(instanceIds);
    }

    private List<HisTask> setHisTask(List<Node> nextNodes, FlowParams flowParams, Node startNode, Long instanceId) {
        Task startTask = FlowFactory.newTask().setInstanceId(instanceId).setDefinitionId(startNode.getDefinitionId()).setNodeCode(startNode.getNodeCode()).setNodeName(startNode.getNodeName()).setNodeType(startNode.getNodeType());
        FlowFactory.dataFillHandler().idFill(startTask);
        return FlowFactory.hisTaskService().setSkipInsHis(startTask, nextNodes, flowParams);
    }

    private void saveFlowInfo(Instance instance, List<Task> addTasks, List<HisTask> hisTasks) {
        List<User> users = FlowFactory.userService().taskAddUsers(addTasks);
        FlowFactory.hisTaskService().saveBatch(hisTasks);
        FlowFactory.taskService().saveBatch(addTasks);
        FlowFactory.userService().saveBatch(users);
        this.save(instance);
    }

    private Instance setStartInstance(Node firstBetweenNode, String businessId, FlowParams flowParams) {
        Instance instance = FlowFactory.newIns();
        Date now = new Date();
        FlowFactory.dataFillHandler().idFill(instance);
        instance.setDefinitionId(firstBetweenNode.getDefinitionId()).setBusinessId(businessId).setNodeType(firstBetweenNode.getNodeType()).setNodeCode(firstBetweenNode.getNodeCode()).setNodeName(firstBetweenNode.getNodeName()).setFlowStatus(ObjectUtil.isNotNull(flowParams.getFlowStatus()) ? flowParams.getFlowStatus() : FlowStatus.TOBESUBMIT.getKey()).setActivityStatus(ActivityStatus.ACTIVITY.getKey()).setVariable(FlowFactory.jsonConvert.mapToStr(flowParams.getVariable())).setCreateTime(now).setUpdateTime(now).setCreateBy(flowParams.getHandler()).setExt(flowParams.getExt());
        return instance;
    }

    private Node getFirstBetween(Node startNode) {
        List<Skip> skips = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(startNode.getDefinitionId()).setNowNodeCode(startNode.getNodeCode()));
        Skip skip = skips.get(0);
        return FlowFactory.nodeService().getOne(FlowFactory.newNode().setDefinitionId(startNode.getDefinitionId()).setNodeCode(skip.getNextNodeCode()));
    }

    private boolean toRemoveTask(List<Long> instanceIds) {
        AssertUtil.isEmpty(instanceIds, "\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<Long> taskIds = new ArrayList<Long>();
        instanceIds.forEach(instanceId -> taskIds.addAll(FlowFactory.taskService().list(FlowFactory.newTask().setInstanceId((Long)instanceId)).stream().map(Task::getId).collect(Collectors.toList())));
        FlowFactory.userService().deleteByTaskIds(taskIds);
        boolean success = FlowFactory.taskService().deleteByInsIds(instanceIds);
        if (success) {
            FlowFactory.hisTaskService().deleteByInsIds(instanceIds);
            return FlowFactory.insService().removeByIds(instanceIds);
        }
        return false;
    }

    @Override
    public boolean active(Long id) {
        Instance instance = (Instance)this.getById(id);
        AssertUtil.isTrue(instance.getActivityStatus().equals(ActivityStatus.ACTIVITY.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u6fc0\u6d3b");
        instance.setActivityStatus(ActivityStatus.ACTIVITY.getKey());
        return this.updateById(instance);
    }

    @Override
    public boolean unActive(Long id) {
        Instance instance = (Instance)this.getById(id);
        AssertUtil.isTrue(instance.getActivityStatus().equals(ActivityStatus.SUSPENDED.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u6302\u8d77");
        instance.setActivityStatus(ActivityStatus.SUSPENDED.getKey());
        return this.updateById(instance);
    }
}

