/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.dao.FlowNodeDao;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.PublishStatus;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.NodeService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ExpressionUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class NodeServiceImpl
extends WarmServiceImpl<FlowNodeDao<Node>, Node>
implements NodeService {
    public NodeService setDao(FlowNodeDao<Node> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public List<Node> getByFlowCode(String flowCode) {
        Definition definition = FlowFactory.defService().getOne(FlowFactory.newDef().setFlowCode(flowCode).setIsPublish(PublishStatus.PUBLISHED.getKey()));
        if (ObjectUtil.isNotNull(definition)) {
            return this.list(FlowFactory.newNode().setDefinitionId(definition.getId()));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Node> getByNodeCodes(List<String> nodeCodes, Long definitionId) {
        return ((FlowNodeDao)this.getDao()).getByNodeCodes(nodeCodes, definitionId);
    }

    @Override
    public List<Node> getNextNodeList(Long definitionId, String nowNodeCode, String anyNodeCode, String skipType, Map<String, Object> variable) {
        return this.getNextByCheckGateway(variable, this.getNextNode(definitionId, nowNodeCode, anyNodeCode, skipType));
    }

    @Override
    public Node getNextNode(Long definitionId, String nowNodeCode, String anyNodeCode, String skipType) {
        AssertUtil.isNull(definitionId, "\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.isEmpty(nowNodeCode, "\u8282\u70b9\u7f16\u7801\u7f3a\u5931");
        AssertUtil.isEmpty(skipType, "\u8df3\u8f6c\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        if (StringUtils.isNotEmpty(anyNodeCode)) {
            return this.getOne(FlowFactory.newNode().setNodeCode(anyNodeCode).setDefinitionId(definitionId));
        }
        Node nowNode = this.getOne(FlowFactory.newNode().setNodeCode(nowNodeCode).setDefinitionId(definitionId));
        AssertUtil.isNull(nowNode, "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e22\u5931!");
        List<Skip> skips = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(definitionId).setNowNodeCode(nowNodeCode));
        AssertUtil.isNull(skips, "\u65e0\u6cd5\u8df3\u8f6c\u5230\u8282\u70b9,\u8bf7\u68c0\u67e5\u8df3\u8f6c\u7c7b\u578b\u662f\u5426\u5339\u914d!");
        Skip nextSkip = this.getSkipByCheck(nowNode, skips, skipType);
        AssertUtil.isNull(nextSkip, "\u65e0\u6cd5\u8df3\u8f6c\u5230\u8282\u70b9,\u8bf7\u68c0\u67e5\u8df3\u8f6c\u7c7b\u578b\u662f\u5426\u5339\u914d!");
        Node nextNode = this.getOne(FlowFactory.newNode().setNodeCode(nextSkip.getNextNodeCode()).setDefinitionId(definitionId));
        AssertUtil.isNull(nextNode, "\u76ee\u6807\u8282\u70b9\u7f16\u7801\u4e0d\u5b58\u5728!");
        AssertUtil.isTrue(NodeType.isStart(nextNode.getNodeType()), "\u7981\u6b62\u9000\u56de\u5230\u7b2c\u4e00\u4e2a\u8282\u70b9");
        return nextNode;
    }

    private Skip getSkipByCheck(Node nowNode, List<Skip> skips, String skipType) {
        if (CollUtil.isEmpty(skips)) {
            return null;
        }
        if (!NodeType.isStart(nowNode.getNodeType()).booleanValue()) {
            skips = skips.stream().filter(t -> {
                if (StringUtils.isNotEmpty(t.getSkipType())) {
                    return skipType.equals(t.getSkipType());
                }
                return true;
            }).collect(Collectors.toList());
        }
        AssertUtil.isEmpty(skips, "\u65e0\u6cd5\u8df3\u8f6c\u5230\u8282\u70b9,\u8bf7\u68c0\u67e5\u8df3\u8f6c\u7c7b\u578b\u662f\u5426\u5339\u914d!");
        return skips.get(0);
    }

    @Override
    public List<Node> getNextByCheckGateway(Map<String, Object> variable, Node nextNode) {
        if (NodeType.isGateWay(nextNode.getNodeType()).booleanValue()) {
            List<Skip> skipsGateway = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(nextNode.getDefinitionId()).setNowNodeCode(nextNode.getNodeCode()));
            if (CollUtil.isEmpty(skipsGateway)) {
                return null;
            }
            if (!NodeType.isStart(nextNode.getNodeType()).booleanValue()) {
                skipsGateway = skipsGateway.stream().filter(t -> {
                    if (NodeType.isGateWaySerial(nextNode.getNodeType()).booleanValue()) {
                        AssertUtil.isEmpty(variable, "\u4e92\u65a5\u7f51\u5173\u5fc5\u987b\u4f20\u9012\u6761\u4ef6!");
                        if (ObjectUtil.isNotNull(t.getSkipCondition())) {
                            return ExpressionUtil.eval(t.getSkipCondition(), variable);
                        }
                    }
                    return true;
                }).collect(Collectors.toList());
            }
            AssertUtil.isEmpty(skipsGateway, "\u672a\u627e\u5230\u8df3\u8f6c\u6761\u4ef6\uff0c\u4e0d\u652f\u6301\u8df3\u8f6c!");
            List<String> nextNodeCodes = StreamUtils.toList(skipsGateway, Skip::getNextNodeCode);
            List<Node> nextNodes = FlowFactory.nodeService().getByNodeCodes(nextNodeCodes, nextNode.getDefinitionId());
            AssertUtil.isEmpty(nextNodes, "\u6d41\u7a0b\u8282\u70b9\u6570\u636e\u7f3a\u5931!");
            return nextNodes;
        }
        return CollUtil.toList(nextNode);
    }

    @Override
    public int deleteNodeByDefIds(Collection<? extends Serializable> defIds) {
        return ((FlowNodeDao)this.getDao()).deleteNodeByDefIds(defIds);
    }
}

