/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.dao.FlowTaskDao;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.dto.ModifyHandler;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.enums.ActivityStatus;
import org.dromara.warm.flow.core.enums.CooperateType;
import org.dromara.warm.flow.core.enums.FlowStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.enums.UserType;
import org.dromara.warm.flow.core.listener.ListenerVariable;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.TaskService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ListenerUtil;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.SqlHelper;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.core.utils.VariableUtil;

public class TaskServiceImpl
extends WarmServiceImpl<FlowTaskDao<Task>, Task>
implements TaskService {
    public TaskService setDao(FlowTaskDao<Task> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public Instance skip(Long taskId, FlowParams flowParams) {
        AssertUtil.isTrue(StringUtils.isNotEmpty(flowParams.getMessage()) && flowParams.getMessage().length() > 500, "\u610f\u89c1\u957f\u5ea6\u8fc7\u957f!");
        Task task = (Task)this.getById(taskId);
        return this.skip(flowParams, task);
    }

    @Override
    public Instance skip(FlowParams flowParams, Task task) {
        R r = this.getAndCheck(task);
        if (!NodeType.isStart(task.getNodeType()).booleanValue()) {
            AssertUtil.isFalse(StringUtils.isNotEmpty(flowParams.getSkipType()), "\u8df3\u8f6c\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        task.setUserList(FlowFactory.userService().listByAssociatedAndTypes(task.getId(), new String[0]));
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task).setFlowParams(flowParams), "start");
        if (this.handleDepute(task, flowParams)) {
            return r.instance;
        }
        this.checkAuth(r.nowNode, task, flowParams);
        if (this.cooperate(r.nowNode, task, flowParams)) {
            return r.instance;
        }
        Node nextNode = FlowFactory.nodeService().getNextNode(task.getDefinitionId(), r.nowNode.getNodeCode(), flowParams.getNodeCode(), flowParams.getSkipType());
        List<Node> nextNodes = FlowFactory.nodeService().getNextByCheckGateway(flowParams.getVariable(), nextNode);
        if (SkipType.isReject(flowParams.getSkipType()).booleanValue()) {
            List<HisTask> rejectHisTasks = FlowFactory.hisTaskService().getByInsAndNodeCodes(task.getInstanceId(), StreamUtils.toList(nextNodes, Node::getNodeCode));
            AssertUtil.isEmpty(rejectHisTasks, "\u672a\u5b8c\u6210\u8fc7\u4efb\u52a1, \u4e0d\u80fd\u9000\u56de");
        }
        ListenerUtil.executeGetNodePermission(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task, nextNodes).setFlowParams(flowParams));
        List<Task> addTasks = this.buildAddTasks(flowParams, task, r.instance, nextNodes, nextNode, r.definition);
        if (CollUtil.isNotEmpty(addTasks)) {
            addTasks.forEach(addTask -> addTask.getPermissionList().replaceAll(s -> VariableUtil.eval(s, flowParams.getVariable())));
        }
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task, nextNodes, addTasks).setFlowParams(flowParams), "assignment");
        this.updateFlowInfo(task, r.instance, addTasks, flowParams, nextNodes);
        this.oneVoteVeto(task, flowParams, nextNode.getNodeCode());
        this.handUndoneTask(r.instance, flowParams);
        ListenerUtil.endCreateListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task, nextNodes, addTasks).setFlowParams(flowParams));
        return r.instance;
    }

    @Override
    public Instance termination(Long taskId, FlowParams flowParams) {
        return this.termination((Task)this.getById(taskId), flowParams);
    }

    @Override
    public Instance termination(Task task, FlowParams flowParams) {
        R r = this.getAndCheck(task);
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task).setFlowParams(flowParams), "start");
        task.setUserList(FlowFactory.userService().listByAssociatedAndTypes(task.getId(), new String[0]));
        this.checkAuth(r.nowNode, task, flowParams);
        Node endNode = FlowFactory.nodeService().getOne(FlowFactory.newNode().setDefinitionId(r.instance.getDefinitionId()).setNodeType(NodeType.END.getKey()));
        r.instance.setNodeType(endNode.getNodeType()).setNodeCode(endNode.getNodeCode()).setNodeName(endNode.getNodeName()).setFlowStatus(ObjectUtil.isNotNull(flowParams.getFlowStatus()) ? flowParams.getFlowStatus() : FlowStatus.TERMINATE.getKey());
        flowParams.setSkipType(SkipType.PASS.getKey()).flowStatus(r.instance.getFlowStatus());
        List<HisTask> insHisList = FlowFactory.hisTaskService().setSkipInsHis(task, Collections.singletonList(endNode), flowParams);
        FlowFactory.hisTaskService().saveBatch(insHisList);
        FlowFactory.insService().updateById(r.instance);
        FlowFactory.userService().deleteByTaskIds(Collections.singletonList(task.getId()));
        this.handUndoneTask(r.instance, flowParams);
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task), "finish");
        return r.instance;
    }

    @Override
    public boolean deleteByInsIds(List<Long> instanceIds) {
        List instanceList = FlowFactory.insService().getByIds(instanceIds);
        for (Instance instance : instanceList) {
            Definition definition = (Definition)FlowFactory.defService().getById(instance.getDefinitionId());
            AssertUtil.isFalse(this.judgeActivityStatus(definition, instance), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u6216\u8005\u5b9e\u4f8b\u5df2\u7ecf\u6302\u8d77\uff0c\u8bf7\u5148\u6fc0\u6d3b");
        }
        return SqlHelper.retBool(((FlowTaskDao)this.getDao()).deleteByInsIds(instanceIds));
    }

    @Override
    public boolean transfer(Long taskId, FlowParams flowParams) {
        List<User> users = FlowFactory.userService().getByProcessedBys(taskId, flowParams.getAddHandlers(), UserType.TRANSFER.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u8f6c\u529e\u4eba\uff0c\u4e0d\u53ef\u8f6c\u529e");
        flowParams.cooperateType(CooperateType.TRANSFER.getKey()).reductionHandlers(Collections.singletonList(flowParams.getHandler()));
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean transfer(Long taskId, String curUser, List<String> permissionFlag, List<String> addHandlers, String message) {
        List<User> users = FlowFactory.userService().getByProcessedBys(taskId, addHandlers, UserType.TRANSFER.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u8f6c\u529e\u4eba\uff0c\u4e0d\u53ef\u8f6c\u529e");
        ModifyHandler modifyHandler = ModifyHandler.build().taskId(taskId).addHandlers(addHandlers).reductionHandlers(Collections.singletonList(curUser)).permissionFlag(permissionFlag).cooperateType(CooperateType.TRANSFER.getKey()).message(message).curUser(curUser).ignore(false);
        return this.updateHandler(modifyHandler);
    }

    @Override
    public boolean depute(Long taskId, FlowParams flowParams) {
        List<User> users = FlowFactory.userService().getByProcessedBys(taskId, flowParams.getAddHandlers(), UserType.DEPUTE.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u53d7\u6258\u4eba\uff0c\u4e0d\u53ef\u59d4\u6258");
        flowParams.cooperateType(CooperateType.DEPUTE.getKey()).reductionHandlers(Collections.singletonList(flowParams.getHandler()));
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean depute(Long taskId, String curUser, List<String> permissionFlag, List<String> addHandlers, String message) {
        List<User> users = FlowFactory.userService().getByProcessedBys(taskId, addHandlers, UserType.DEPUTE.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u53d7\u6258\u4eba\uff0c\u4e0d\u53ef\u59d4\u6258");
        ModifyHandler modifyHandler = ModifyHandler.build().taskId(taskId).addHandlers(addHandlers).reductionHandlers(Collections.singletonList(curUser)).permissionFlag(permissionFlag).cooperateType(CooperateType.DEPUTE.getKey()).message(message).curUser(curUser).ignore(false);
        return this.updateHandler(modifyHandler);
    }

    @Override
    public boolean addSignature(Long taskId, FlowParams flowParams) {
        List<User> users = FlowFactory.userService().getByProcessedBys(taskId, flowParams.getAddHandlers(), UserType.APPROVAL.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u5f85\u529e\u4eba\uff0c\u4e0d\u53ef\u52a0\u7b7e");
        flowParams.cooperateType(CooperateType.ADD_SIGNATURE.getKey());
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean addSignature(Long taskId, String curUser, List<String> permissionFlag, List<String> addHandlers, String message) {
        List<User> users = FlowFactory.userService().getByProcessedBys(taskId, addHandlers, UserType.APPROVAL.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u5f85\u529e\u4eba\uff0c\u4e0d\u53ef\u52a0\u7b7e");
        ModifyHandler modifyHandler = ModifyHandler.build().taskId(taskId).addHandlers(addHandlers).permissionFlag(permissionFlag).cooperateType(CooperateType.ADD_SIGNATURE.getKey()).message(message).curUser(curUser).ignore(false);
        return this.updateHandler(modifyHandler);
    }

    @Override
    public boolean reductionSignature(Long taskId, FlowParams flowParams) {
        List<User> users = FlowFactory.userService().list(FlowFactory.newUser().setAssociated(taskId).setType(UserType.APPROVAL.getKey()));
        AssertUtil.isTrue(CollUtil.isEmpty(users) || users.size() == 1, "\u529e\u7406\u4eba\u4e0d\u8db3\u6216\u8005\u53ea\u6709\u4e00\u4eba\uff0c\u4e0d\u53ef\u51cf\u7b7e");
        flowParams.cooperateType(CooperateType.REDUCTION_SIGNATURE.getKey());
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean reductionSignature(Long taskId, String curUser, List<String> permissionFlag, List<String> reductionHandlers, String message) {
        List<User> users = FlowFactory.userService().list(FlowFactory.newUser().setAssociated(taskId).setType(UserType.APPROVAL.getKey()));
        AssertUtil.isTrue(CollUtil.isEmpty(users) || users.size() == 1, "\u529e\u7406\u4eba\u4e0d\u8db3\u6216\u8005\u53ea\u6709\u4e00\u4eba\uff0c\u4e0d\u53ef\u51cf\u7b7e");
        ModifyHandler modifyHandler = ModifyHandler.build().taskId(taskId).reductionHandlers(reductionHandlers).permissionFlag(permissionFlag).cooperateType(CooperateType.REDUCTION_SIGNATURE.getKey()).message(message).curUser(curUser).ignore(false);
        return this.updateHandler(modifyHandler);
    }

    @Override
    public boolean updateHandler(Long taskId, FlowParams flowParams) {
        R r = this.getAndCheck(taskId);
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, null, r.task), "start");
        if (!flowParams.isIgnore()) {
            List<String> permissions = flowParams.getPermissionFlag();
            List<String> taskPermissions = FlowFactory.userService().getPermission(taskId, UserType.APPROVAL.getKey(), UserType.TRANSFER.getKey(), UserType.DEPUTE.getKey());
            AssertUtil.isTrue(CollUtil.isNotEmpty(taskPermissions) && (CollUtil.isEmpty(permissions) || CollUtil.notContainsAny(permissions, (Collection<String>)taskPermissions)), "\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650!");
        }
        flowParams.skipType(SkipType.NONE.getKey());
        List<HisTask> hisTasks = null;
        if (CollUtil.isNotEmpty(flowParams.getReductionHandlers())) {
            for (String reductionHandler : flowParams.getReductionHandlers()) {
                FlowFactory.userService().remove(FlowFactory.newUser().setAssociated(taskId).setProcessedBy(reductionHandler));
            }
            hisTasks = FlowFactory.hisTaskService().setCooperateHis(r.task, r.nowNode, flowParams, flowParams.getReductionHandlers());
        }
        if (CollUtil.isNotEmpty(flowParams.getAddHandlers())) {
            String type = CooperateType.TRANSFER.getKey().equals(flowParams.getCooperateType()) ? UserType.TRANSFER.getKey() : (CooperateType.DEPUTE.getKey().equals(flowParams.getCooperateType()) ? UserType.DEPUTE.getKey() : UserType.APPROVAL.getKey());
            FlowFactory.userService().saveBatch(StreamUtils.toList(flowParams.getAddHandlers(), permission -> FlowFactory.userService().structureUser(taskId, (String)permission, type, flowParams.getHandler())));
            hisTasks = FlowFactory.hisTaskService().setCooperateHis(r.task, r.nowNode, flowParams, flowParams.getAddHandlers());
        }
        if (CollUtil.isNotEmpty(hisTasks)) {
            FlowFactory.hisTaskService().saveBatch(hisTasks);
        }
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), r.task), "finish");
        return true;
    }

    @Override
    public boolean updateHandler(ModifyHandler modifyHandler) {
        return this.updateHandler(modifyHandler.getTaskId(), new FlowParams().handler(modifyHandler.getCurUser()).permissionFlag(modifyHandler.getPermissionFlag()).addHandlers(modifyHandler.getAddHandlers()).reductionHandlers(modifyHandler.getReductionHandlers()).cooperateType(modifyHandler.getCooperateType()).message(modifyHandler.getMessage()).ignore(modifyHandler.isIgnore()));
    }

    @Override
    public Instance retrieve(Long instanceId, FlowParams flowParams) {
        Instance instance = (Instance)FlowFactory.insService().getById(instanceId);
        AssertUtil.isNull(instance, "\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5931\u8d25!");
        AssertUtil.isFalse(instance.getCreateBy().equals(flowParams.getHandler()), "\u4e0d\u662f\u5f53\u524d\u6d41\u7a0b\u7684\u53d1\u8d77\u4eba\uff0c\u65e0\u6cd5\u53d6\u56de");
        if (StringUtils.isEmpty(flowParams.getNodeCode())) {
            flowParams.nodeCode(FlowFactory.nodeService().getOne(FlowFactory.newNode().setDefinitionId(instance.getDefinitionId()).setNodeType(NodeType.START.getKey())).getNodeCode());
        }
        Definition definition = (Definition)FlowFactory.defService().getById(instance.getDefinitionId());
        AssertUtil.isFalse(this.judgeActivityStatus(definition, instance), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u6216\u8005\u5b9e\u4f8b\u5df2\u7ecf\u6302\u8d77\uff0c\u8bf7\u5148\u6fc0\u6d3b");
        AssertUtil.isTrue(NodeType.isEnd(instance.getNodeType()), "\u6d41\u7a0b\u5df2\u5b8c\u6210\uff01");
        AssertUtil.isTrue(StringUtils.isNotEmpty(flowParams.getMessage()) && flowParams.getMessage().length() > 500, "\u610f\u89c1\u957f\u5ea6\u8fc7\u957f!");
        Node nextNode = FlowFactory.nodeService().getOne(FlowFactory.newNode().setNodeCode(flowParams.getNodeCode()).setDefinitionId(instance.getDefinitionId()));
        AssertUtil.isNull(nextNode, "\u76ee\u6807\u8282\u70b9\u4e3a\u7a7a!");
        AssertUtil.isTrue(NodeType.isEnd(nextNode.getNodeType()), "\u76ee\u6807\u8282\u70b9\u662f\u7ed3\u675f\u8282\u70b9\uff0c\u4e0d\u53ef\u8df3\u8f6c");
        List<Task> curTaskList = this.list(FlowFactory.newTask().setInstanceId(instance.getId()));
        AssertUtil.isEmpty(curTaskList, "\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u4efb\u52a1");
        Task nextTask = this.addTask(nextNode, instance, definition, flowParams);
        flowParams.setSkipType(SkipType.REJECT.getKey());
        if (StringUtils.isNotEmpty(flowParams.getFlowStatus())) {
            flowParams.flowStatus(FlowStatus.RETRIEVE.getKey());
        }
        this.removeByIds(StreamUtils.toList(curTaskList, Task::getId));
        FlowFactory.userService().deleteByTaskIds(StreamUtils.toList(curTaskList, Task::getId));
        FlowFactory.hisTaskService().saveBatch(StreamUtils.toList(curTaskList, task -> FlowFactory.hisTaskService().setSkipHisTask((Task)task, nextNode, flowParams)));
        this.setInsFinishInfo(instance, CollUtil.toList(nextTask), flowParams);
        FlowFactory.insService().updateById(instance);
        List<User> users = FlowFactory.userService().taskAddUsers(CollUtil.toList(nextTask));
        FlowFactory.userService().saveBatch(users);
        this.save(nextTask);
        return instance;
    }

    @Override
    public Task addTask(Node node, Instance instance, Definition definition, FlowParams flowParams) {
        Task addTask = FlowFactory.newTask();
        FlowFactory.dataFillHandler().idFill(addTask);
        addTask.setDefinitionId(instance.getDefinitionId()).setInstanceId(instance.getId()).setNodeCode(node.getNodeCode()).setNodeName(node.getNodeName()).setNodeType(node.getNodeType()).setCreateTime(new Date()).setPermissionList(CollUtil.isNotEmpty(node.getDynamicPermissionFlagList()) ? node.getDynamicPermissionFlagList() : StringUtils.str2List(node.getPermissionFlag(), ","));
        if (StringUtils.isNotEmpty(node.getFormCustom()) && StringUtils.isNotEmpty(node.getFormPath())) {
            addTask.setFormCustom(node.getFormCustom()).setFormPath(node.getFormPath());
        } else {
            addTask.setFormCustom(definition.getFormCustom()).setFormPath(definition.getFormPath());
        }
        return addTask;
    }

    @Override
    public String setFlowStatus(Integer nodeType, String skipType) {
        if (NodeType.isStart(nodeType).booleanValue()) {
            return FlowStatus.TOBESUBMIT.getKey();
        }
        if (NodeType.isEnd(nodeType).booleanValue()) {
            return FlowStatus.FINISHED.getKey();
        }
        if (SkipType.isReject(skipType).booleanValue()) {
            return FlowStatus.REJECT.getKey();
        }
        return FlowStatus.APPROVAL.getKey();
    }

    @Override
    public Task getNextTask(List<Task> tasks) {
        if (tasks.size() == 1) {
            return tasks.get(0);
        }
        for (Task task : tasks) {
            if (!NodeType.isEnd(task.getNodeType()).booleanValue()) continue;
            return task;
        }
        return tasks.stream().max(Comparator.comparingLong(Task::getId)).orElse(null);
    }

    private R getAndCheck(Long taskId) {
        return this.getAndCheck((Task)this.getById(taskId));
    }

    private R getAndCheck(Task task) {
        AssertUtil.isNull(task, "\u5f85\u529e\u4efb\u52a1\u83b7\u53d6\u5931\u8d25!");
        Instance instance = (Instance)FlowFactory.insService().getById(task.getInstanceId());
        AssertUtil.isNull(instance, "\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5931\u8d25!");
        Definition definition = (Definition)FlowFactory.defService().getById(instance.getDefinitionId());
        AssertUtil.isFalse(this.judgeActivityStatus(definition, instance), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u6216\u8005\u5b9e\u4f8b\u5df2\u7ecf\u6302\u8d77\uff0c\u8bf7\u5148\u6fc0\u6d3b");
        AssertUtil.isTrue(NodeType.isEnd(instance.getNodeType()), "\u6d41\u7a0b\u5df2\u5b8c\u6210\uff01");
        Node nowNode = FlowFactory.nodeService().getOne(FlowFactory.newNode().setNodeCode(task.getNodeCode()).setDefinitionId(task.getDefinitionId()));
        AssertUtil.isNull(nowNode, "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e22\u5931!");
        return new R(instance, definition, nowNode, task);
    }

    private boolean handleDepute(Task task, FlowParams flowParams) {
        User entrustedUser = FlowFactory.userService().getOne(FlowFactory.newUser().setAssociated(task.getId()).setProcessedBy(flowParams.getHandler()).setType(UserType.DEPUTE.getKey()));
        if (ObjectUtil.isNull(entrustedUser)) {
            return false;
        }
        HisTask hisTask = FlowFactory.hisTaskService().setDeputeHisTask(task, flowParams, entrustedUser);
        FlowFactory.hisTaskService().save(hisTask);
        FlowFactory.userService().removeById(entrustedUser.getId());
        User deputeUser = FlowFactory.userService().getOne(FlowFactory.newUser().setAssociated(task.getId()).setProcessedBy(entrustedUser.getCreateBy()).setType(UserType.APPROVAL.getKey()));
        if (ObjectUtil.isNull(deputeUser)) {
            User newUser = FlowFactory.userService().structureUser(entrustedUser.getAssociated(), entrustedUser.getCreateBy(), UserType.APPROVAL.getKey(), entrustedUser.getProcessedBy());
            FlowFactory.userService().save(newUser);
        }
        return true;
    }

    private boolean cooperate(Node nowNode, Task task, FlowParams flowParams) {
        BigDecimal nodeRatio = nowNode.getNodeRatio();
        if (CooperateType.isOrSign(nodeRatio)) {
            return false;
        }
        List<User> todoList = FlowFactory.userService().listByAssociatedAndTypes(task.getId(), UserType.APPROVAL.getKey(), UserType.TRANSFER.getKey(), UserType.DEPUTE.getKey());
        AssertUtil.isEmpty(flowParams.getHandler(), "\u4f1a\u7b7e\u7968\u7b7e\u65f6\uff0c\u529e\u7406\u4eba\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        User todoUser = CollUtil.getOne(StreamUtils.filter(todoList, u -> Objects.equals(u.getProcessedBy(), flowParams.getHandler())));
        AssertUtil.isNull(todoUser, "\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650!");
        if (todoList.size() == 1) {
            return false;
        }
        List<User> restList = StreamUtils.filter(todoList, u -> !Objects.equals(u.getProcessedBy(), flowParams.getHandler()));
        if (CooperateType.isCountersign(nodeRatio) && SkipType.isReject(flowParams.getSkipType()).booleanValue()) {
            FlowFactory.userService().removeByIds(StreamUtils.toList(restList, User::getId));
            return false;
        }
        List<HisTask> doneList = FlowFactory.hisTaskService().listByTaskIdAndCooperateTypes(task.getId(), CooperateType.isCountersign(nodeRatio) ? CooperateType.COUNTERSIGN.getKey() : CooperateType.VOTE.getKey());
        doneList = CollUtil.emptyDefault(doneList, Collections.emptyList());
        BigDecimal all = BigDecimal.ZERO.add(BigDecimal.valueOf(todoList.size())).add(BigDecimal.valueOf(doneList.size()));
        List<HisTask> donePassList = StreamUtils.filter(doneList, hisTask -> Objects.equals(hisTask.getSkipType(), SkipType.PASS.getKey()));
        List<HisTask> doneRejectList = StreamUtils.filter(doneList, hisTask -> Objects.equals(hisTask.getSkipType(), SkipType.REJECT.getKey()));
        boolean isPass = SkipType.isPass(flowParams.getSkipType());
        BigDecimal passRatio = (isPass ? BigDecimal.ONE : BigDecimal.ZERO).add(BigDecimal.valueOf(donePassList.size())).divide(all, 4, RoundingMode.HALF_UP).multiply(CooperateType.ONE_HUNDRED);
        BigDecimal rejectRatio = (isPass ? BigDecimal.ZERO : BigDecimal.ONE).add(BigDecimal.valueOf(doneRejectList.size())).divide(all, 4, RoundingMode.HALF_UP).multiply(CooperateType.ONE_HUNDRED);
        if (!isPass && rejectRatio.compareTo(CooperateType.ONE_HUNDRED.subtract(nodeRatio)) > 0) {
            FlowFactory.userService().removeByIds(StreamUtils.toList(restList, User::getId));
            return false;
        }
        if (passRatio.compareTo(nodeRatio) >= 0) {
            FlowFactory.userService().removeByIds(StreamUtils.toList(restList, User::getId));
            return false;
        }
        HisTask hisTask2 = FlowFactory.hisTaskService().setSignHisTask(task, flowParams, nodeRatio, isPass);
        FlowFactory.hisTaskService().save(hisTask2);
        FlowFactory.userService().removeById(todoUser.getId());
        return true;
    }

    private List<Task> buildAddTasks(FlowParams flowParams, Task task, Instance instance, List<Node> nextNodes, Node nextNode, Definition definition) {
        boolean buildFlag = false;
        if (!NodeType.isGateWayParallel(nextNode.getNodeType()).booleanValue()) {
            buildFlag = true;
        } else if (this.gateWayParallelIsFinish(task, instance, nextNode.getNodeCode())) {
            buildFlag = true;
        }
        if (buildFlag) {
            ArrayList<Task> addTasks = new ArrayList<Task>();
            for (Node node : nextNodes) {
                addTasks.add(this.addTask(node, instance, definition, flowParams));
            }
            return addTasks;
        }
        return null;
    }

    private boolean gateWayParallelIsFinish(Task task, Instance instance, String nextNodeCode) {
        List<Skip> allSkips = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(instance.getDefinitionId()));
        Map<String, List<Skip>> skipNextMap = StreamUtils.groupByKeyFilter(skip -> !task.getNodeCode().equals(skip.getNowNodeCode()) || !nextNodeCode.equals(skip.getNextNodeCode()), allSkips, Skip::getNextNodeCode);
        List<Skip> oneLastSkips = skipNextMap.get(nextNodeCode);
        if (CollUtil.isEmpty(oneLastSkips)) {
            return true;
        }
        List<HisTask> hisTaskList = FlowFactory.hisTaskService().getNoReject(instance.getId());
        int wayParallelIsFinish = 0;
        if (CollUtil.isNotEmpty(oneLastSkips)) {
            for (Skip oneLastSkip : oneLastSkips) {
                HisTask oneLastHisTask = FlowFactory.hisTaskService().getNoReject(oneLastSkip.getNowNodeCode(), null, hisTaskList);
                if (ObjectUtil.isNull(oneLastHisTask)) {
                    return false;
                }
                List<Skip> twoLastSkips = skipNextMap.get(oneLastSkip.getNowNodeCode());
                for (Skip twoLastSkip : twoLastSkips) {
                    if (NodeType.isStart(twoLastSkip.getNowNodeType()).booleanValue()) {
                        ++wayParallelIsFinish;
                        continue;
                    }
                    if (NodeType.isGateWay(twoLastSkip.getNowNodeType()).booleanValue()) {
                        List<Skip> threeLastSkips = skipNextMap.get(twoLastSkip.getNowNodeCode());
                        for (Skip threeLastSkip : threeLastSkips) {
                            HisTask threeLastHisTask = FlowFactory.hisTaskService().getNoReject(threeLastSkip.getNowNodeCode(), null, hisTaskList);
                            if (!ObjectUtil.isNotNull(threeLastHisTask) || !threeLastHisTask.getUpdateTime().before(oneLastHisTask.getUpdateTime()) && !threeLastHisTask.getUpdateTime().equals(oneLastHisTask.getUpdateTime())) continue;
                            ++wayParallelIsFinish;
                        }
                        continue;
                    }
                    HisTask twoLastHisTask = FlowFactory.hisTaskService().getNoReject(twoLastSkip.getNowNodeCode(), null, hisTaskList);
                    if (!ObjectUtil.isNotNull(twoLastHisTask) || !twoLastHisTask.getUpdateTime().before(oneLastHisTask.getUpdateTime()) && !twoLastHisTask.getUpdateTime().equals(oneLastHisTask.getUpdateTime())) continue;
                    ++wayParallelIsFinish;
                }
            }
        }
        return wayParallelIsFinish == oneLastSkips.size();
    }

    private void checkAuth(Node NowNode, Task task, FlowParams flowParams) {
        if (flowParams.isIgnore()) {
            return;
        }
        List<String> permissions = CollUtil.isNotEmpty(NowNode.getDynamicPermissionFlagList()) ? NowNode.getDynamicPermissionFlagList() : StreamUtils.toList(task.getUserList(), User::getProcessedBy);
        AssertUtil.isTrue(CollUtil.isNotEmpty(permissions) && (CollUtil.isEmpty(flowParams.getPermissionFlag()) || CollUtil.notContainsAny(flowParams.getPermissionFlag(), permissions)), "\u65e0\u6cd5\u8df3\u8f6c\u5230\u8be5\u8282\u70b9,\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650!");
    }

    private void setInsFinishInfo(Instance instance, List<Task> addTasks, FlowParams flowParams) {
        instance.setUpdateTime(new Date());
        Map<String, Object> variable = flowParams.getVariable();
        if (MapUtil.isNotEmpty(variable)) {
            String variableStr = instance.getVariable();
            Map<String, Object> deserialize = FlowFactory.jsonConvert.strToMap(variableStr);
            deserialize.putAll(variable);
            instance.setVariable(FlowFactory.jsonConvert.mapToStr(deserialize));
        }
        if (CollUtil.isNotEmpty(addTasks)) {
            addTasks.removeIf(addTask -> {
                if (NodeType.isEnd(addTask.getNodeType()).booleanValue()) {
                    instance.setNodeType(addTask.getNodeType()).setNodeCode(addTask.getNodeCode()).setNodeName(addTask.getNodeName()).setFlowStatus(ObjectUtil.isNotNull(flowParams.getFlowStatus()) ? flowParams.getFlowStatus() : FlowStatus.FINISHED.getKey());
                    return true;
                }
                return false;
            });
        }
        if (CollUtil.isNotEmpty(addTasks) && !NodeType.isEnd(instance.getNodeType()).booleanValue()) {
            Task nextTask = this.getNextTask(addTasks);
            instance.setNodeType(nextTask.getNodeType()).setNodeCode(nextTask.getNodeCode()).setNodeName(nextTask.getNodeName()).setFlowStatus(ObjectUtil.isNotNull(flowParams.getFlowStatus()) ? flowParams.getFlowStatus() : this.setFlowStatus(nextTask.getNodeType(), flowParams.getSkipType()));
        }
    }

    private void oneVoteVeto(Task task, FlowParams flowParams, String nextNodeCode) {
        if (SkipType.isReject(flowParams.getSkipType()).booleanValue()) {
            List<Task> tasks = this.list(FlowFactory.newTask().setInstanceId(task.getInstanceId()));
            List<Skip> allSkips = FlowFactory.skipService().list(FlowFactory.newSkip().setDefinitionId(task.getDefinitionId()));
            Map<String, List<Skip>> skipMap = StreamUtils.groupByKeyFilter(skip -> !task.getNodeCode().equals(skip.getNextNodeCode()), allSkips, Skip::getNextNodeCode);
            ArrayList<Task> noDoneTasks = new ArrayList<Task>();
            for (Task flowTask : tasks) {
                List<Skip> lastSkips;
                if (task.getNodeCode().equals(flowTask.getNodeCode()) || !this.judgeReject(nextNodeCode, lastSkips = skipMap.get(flowTask.getNodeCode()), skipMap)) continue;
                noDoneTasks.add(flowTask);
            }
            if (CollUtil.isNotEmpty(noDoneTasks)) {
                this.convertHisTask(noDoneTasks, flowParams, FlowStatus.INVALID.getKey());
            }
        }
    }

    private boolean judgeReject(String nextNodeCode, List<Skip> lastSkips, Map<String, List<Skip>> skipMap) {
        Iterator<Skip> iterator;
        if (CollUtil.isNotEmpty(lastSkips) && (iterator = lastSkips.iterator()).hasNext()) {
            Skip lastSkip = iterator.next();
            if (nextNodeCode.equals(lastSkip.getNowNodeCode())) {
                return true;
            }
            List<Skip> lastLastSkips = skipMap.get(lastSkip.getNowNodeCode());
            return this.judgeReject(nextNodeCode, lastLastSkips, skipMap);
        }
        return false;
    }

    private void handUndoneTask(Instance instance, FlowParams flowParams) {
        List<Task> taskList;
        if (NodeType.isEnd(instance.getNodeType()).booleanValue() && CollUtil.isNotEmpty(taskList = this.list(FlowFactory.newTask().setInstanceId(instance.getId())))) {
            this.convertHisTask(taskList, flowParams, FlowStatus.AUTO_PASS.getKey());
        }
    }

    private void convertHisTask(List<Task> taskList, FlowParams flowParams, String flowStatus) {
        ArrayList<HisTask> insHisList = new ArrayList<HisTask>();
        for (Task task : taskList) {
            List<User> userList = FlowFactory.userService().listByAssociatedAndTypes(task.getId(), new String[0]);
            List<HisTask> hisTasks = FlowFactory.hisTaskService().autoHisTask(flowParams, flowStatus, task, userList, CooperateType.APPROVAL.getKey());
            hisTasks.forEach(hisTask -> hisTask.setExt(flowParams.getHisTaskExt()));
            insHisList.addAll(hisTasks);
        }
        this.removeByIds(StreamUtils.toList(taskList, Task::getId));
        FlowFactory.hisTaskService().saveBatch(insHisList);
        FlowFactory.userService().deleteByTaskIds(StreamUtils.toList(taskList, Task::getId));
    }

    private void updateFlowInfo(Task task, Instance instance, List<Task> addTasks, FlowParams flowParams, List<Node> nextNodes) {
        List<HisTask> insHisList = FlowFactory.hisTaskService().setSkipInsHis(task, nextNodes, flowParams);
        FlowFactory.hisTaskService().saveBatch(insHisList);
        List<User> users = FlowFactory.userService().setSkipUser(addTasks, task.getId());
        this.removeById(task.getId());
        this.setInsFinishInfo(instance, addTasks, flowParams);
        if (CollUtil.isNotEmpty(addTasks)) {
            this.saveBatch(addTasks);
        }
        FlowFactory.insService().updateById(instance);
        FlowFactory.userService().saveBatch(users);
    }

    private boolean judgeActivityStatus(Definition definition, Instance instance) {
        return Objects.equals(definition.getActivityStatus(), ActivityStatus.ACTIVITY.getKey()) && Objects.equals(instance.getActivityStatus(), ActivityStatus.ACTIVITY.getKey());
    }

    private static class R {
        public final Instance instance;
        public final Definition definition;
        public final Node nowNode;
        public final Task task;

        public R(Instance instance, Definition definition, Node nowNode, Task task) {
            this.instance = instance;
            this.definition = definition;
            this.nowNode = nowNode;
            this.task = task;
        }
    }
}

