/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.expression.ExpressionStrategy;
import org.dromara.warm.flow.core.expression.ExpressionStrategyEq;
import org.dromara.warm.flow.core.expression.ExpressionStrategyGe;
import org.dromara.warm.flow.core.expression.ExpressionStrategyGt;
import org.dromara.warm.flow.core.expression.ExpressionStrategyLe;
import org.dromara.warm.flow.core.expression.ExpressionStrategyLike;
import org.dromara.warm.flow.core.expression.ExpressionStrategyLt;
import org.dromara.warm.flow.core.expression.ExpressionStrategyNe;
import org.dromara.warm.flow.core.expression.ExpressionStrategyNotLike;
import org.dromara.warm.flow.core.utils.StringUtils;

public class ExpressionUtil {
    private static final Map<String, ExpressionStrategy> map = new HashMap<String, ExpressionStrategy>();

    private ExpressionUtil() {
    }

    public static void setExpression(ExpressionStrategy expressionStrategy) {
        map.put(expressionStrategy.getType(), expressionStrategy);
    }

    public static boolean eval(String expression, Map<String, Object> variable) {
        if (StringUtils.isEmpty(expression)) {
            return true;
        }
        AtomicBoolean flag = new AtomicBoolean(false);
        map.forEach((k, v) -> {
            if (expression.startsWith(k + "|")) {
                if (v == null) {
                    throw new FlowException("\u6761\u4ef6\u8868\u8fbe\u5f0f\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                flag.set(v.eval(expression.replace(k + "|", ""), variable));
            }
        });
        return flag.get();
    }

    static {
        ExpressionUtil.setExpression(new ExpressionStrategyEq());
        ExpressionUtil.setExpression(new ExpressionStrategyGe());
        ExpressionUtil.setExpression(new ExpressionStrategyGt());
        ExpressionUtil.setExpression(new ExpressionStrategyLe());
        ExpressionUtil.setExpression(new ExpressionStrategyLike());
        ExpressionUtil.setExpression(new ExpressionStrategyLt());
        ExpressionUtil.setExpression(new ExpressionStrategyNe());
        ExpressionUtil.setExpression(new ExpressionStrategyNotLike());
    }
}

