/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.dromara.warm.flow.core.utils.ObjectUtil;

public class ServiceLoaderUtil {
    public static <T> T loadFirst(Class<T> clazz) {
        Iterator<T> iterator = ServiceLoaderUtil.load(clazz).iterator();
        while (iterator.hasNext()) {
            try {
                return iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        return null;
    }

    public static <T> List<T> loadList(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        ServiceLoader<T> serviceLoader = ServiceLoaderUtil.load(clazz);
        Iterator<T> serviceIterator = serviceLoader.iterator();
        while (serviceIterator.hasNext()) {
            try {
                list.add(serviceIterator.next());
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        return list;
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz) {
        return ServiceLoaderUtil.load(clazz, null);
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz, ClassLoader loader) {
        return ServiceLoader.load(clazz, ObjectUtil.defaultIfNull(loader, ServiceLoaderUtil::getClassLoader));
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ServiceLoaderUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ServiceLoaderUtil.class.getClassLoader())) {
            classLoader = ServiceLoaderUtil.getSystemClassLoader();
        }
        return classLoader;
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }
}

