/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.spring.boot.config;

import javax.sql.DataSource;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.plugin.modes.sb.config.BeanConfig;
import org.dromara.warm.plugin.modes.sb.utils.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@Configuration
@ConditionalOnProperty(value={"warm-flow.enabled"}, havingValue="true", matchIfMissing=true)
public class FlowAutoConfig
extends BeanConfig {
    private static final Logger log = LoggerFactory.getLogger(FlowAutoConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public JpaProperties jpaProperties() {
        return new JpaProperties();
    }

    @Bean(name={"entityManagerFactoryWarmFlow"})
    @DependsOn(value={"warmFlowSpringUtil"})
    public LocalContainerEntityManagerFactoryBean primaryEntityManagerFactory(DataSource dataSource, JpaProperties jpaProperties) throws ClassNotFoundException {
        LocalContainerEntityManagerFactoryBean factory = new LocalContainerEntityManagerFactoryBean();
        factory.setDataSource(dataSource);
        factory.setJpaPropertyMap(jpaProperties.getProperties());
        factory.setMappingResources(new String[]{"META-INF/warm-flow-orm.xml"});
        factory.setPersistenceXmlLocation("classpath:/META-INF/warm-flow-persistence.xml");
        String jpaPersistenceProvider = ((Environment)SpringUtil.getBean(Environment.class)).getProperty("warm-flow.jpa_persistence_provider");
        log.info("warm-flow use jpa persistence provider to be: {}", (Object)jpaPersistenceProvider);
        if (jpaPersistenceProvider == null) {
            throw new FlowException("jpa_persistence_provider\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        factory.setPersistenceProviderClass(Class.forName(jpaPersistenceProvider));
        factory.setPersistenceUnitName("warm-flow-jpa");
        return factory;
    }
}

