/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.solon.jpa;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import org.noear.solon.data.tran.TranListener;
import org.noear.solon.data.tran.TranUtils;

public class EntityManagerProxy
implements EntityManager {
    private final EntityManager entityManager;

    public EntityManagerProxy(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    private <T extends EntityManager> T tranTry(T entityManager) {
        EntityTransaction transaction;
        if (TranUtils.inTrans() && !(transaction = entityManager.getTransaction()).isActive()) {
            transaction.begin();
            TranUtils.listen((TranListener)new TranListener(){

                public void beforeCommit(boolean readOnly) throws Throwable {
                    if (readOnly) {
                        transaction.setRollbackOnly();
                    }
                    transaction.commit();
                }

                public void afterCompletion(int status) {
                    if (status == 1) {
                        transaction.rollback();
                    }
                }
            });
        }
        return entityManager;
    }

    public void persist(Object entity) {
        this.tranTry(this.entityManager);
        this.entityManager.persist(entity);
    }

    public <T> T merge(T entity) {
        this.tranTry(this.entityManager);
        return (T)this.entityManager.merge(entity);
    }

    public void remove(Object entity) {
        this.tranTry(this.entityManager);
        this.entityManager.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.tranTry(this.entityManager);
        return (T)this.entityManager.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        this.tranTry(this.entityManager);
        return (T)this.entityManager.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        this.tranTry(this.entityManager);
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        this.tranTry(this.entityManager);
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.tranTry(this.entityManager);
        return (T)this.entityManager.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.tranTry(this.entityManager);
        this.entityManager.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.entityManager.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.tranTry(this.entityManager);
        this.entityManager.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.tranTry(this.entityManager);
        this.entityManager.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.tranTry(this.entityManager);
        this.entityManager.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.tranTry(this.entityManager);
        this.entityManager.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.tranTry(this.entityManager);
        this.entityManager.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.tranTry(this.entityManager);
        this.entityManager.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.tranTry(this.entityManager);
        this.entityManager.clear();
    }

    public void detach(Object entity) {
        this.tranTry(this.entityManager);
        this.entityManager.detach(entity);
    }

    public boolean contains(Object entity) {
        this.tranTry(this.entityManager);
        return this.entityManager.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        this.tranTry(this.entityManager);
        return this.entityManager.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.tranTry(this.entityManager);
        this.entityManager.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        this.tranTry(this.entityManager);
        return this.entityManager.getProperties();
    }

    public Query createQuery(String qlString) {
        this.tranTry(this.entityManager);
        return this.entityManager.createQuery(qlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.tranTry(this.entityManager);
        return this.entityManager.createQuery(criteriaQuery);
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        this.tranTry(this.entityManager);
        return this.entityManager.createQuery(updateQuery);
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        this.tranTry(this.entityManager);
        return this.entityManager.createQuery(deleteQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        this.tranTry(this.entityManager);
        return this.entityManager.createQuery(qlString, resultClass);
    }

    public Query createNamedQuery(String name) {
        this.tranTry(this.entityManager);
        return this.entityManager.createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        this.tranTry(this.entityManager);
        return this.entityManager.createNamedQuery(name, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        this.tranTry(this.entityManager);
        return this.entityManager.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        this.tranTry(this.entityManager);
        return this.entityManager.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.tranTry(this.entityManager);
        return this.entityManager.createNativeQuery(sqlString, resultSetMapping);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        this.tranTry(this.entityManager);
        return this.entityManager.createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        this.tranTry(this.entityManager);
        return this.entityManager.createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.tranTry(this.entityManager);
        return this.entityManager.createStoredProcedureQuery(procedureName, resultClasses);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.tranTry(this.entityManager);
        return this.entityManager.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public void joinTransaction() {
        this.entityManager.joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        return this.entityManager.isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.entityManager.unwrap(cls);
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }

    public void close() {
        this.entityManager.close();
    }

    public boolean isOpen() {
        return this.entityManager.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.entityManager.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManager.getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManager.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.entityManager.getMetamodel();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.entityManager.createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.entityManager.createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.entityManager.getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.entityManager.getEntityGraphs(entityClass);
    }
}

