/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.solon.jpa;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.solon.jpa.EntityManagerProxy;
import org.noear.solon.Solon;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;

public class PersistenceContextBeanInjector
implements BeanInjector<PersistenceContext> {
    private ConcurrentHashMap<String, EntityManagerFactory> ENTITY_MANAGER_FACTORIES = new ConcurrentHashMap();

    public void doInject(VarHolder varH, PersistenceContext anno) {
        varH.context().getWrapAsync(DataSource.class, dsBw -> {
            if (dsBw.raw() instanceof DataSource) {
                this.inject0(anno, varH, (BeanWrap)dsBw);
            }
        });
    }

    private void inject0(PersistenceContext anno, VarHolder varH, BeanWrap dsBw) {
        String unitName = anno.unitName();
        if (StringUtils.isEmpty((String)unitName)) {
            unitName = "default";
        }
        Props dsProps = Solon.cfg().getProp(unitName);
        String datasource = dsProps.get("datasource");
        if (!Objects.equals(dsBw.name(), datasource)) {
            return;
        }
        Props properties = dsProps.getProp("properties");
        properties.put((Object)"hibernate.connection.datasource", dsBw.raw());
        EntityManagerFactory entityManagerFactory = this.ENTITY_MANAGER_FACTORIES.computeIfAbsent(unitName, key -> Persistence.createEntityManagerFactory((String)key, (Map)properties));
        varH.setValue((Object)new EntityManagerProxy(entityManagerFactory.createEntityManager()));
    }
}

