/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.orm.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.orm.dao.FlowUserDao;
import org.dromara.warm.flow.core.utils.ArrayUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.core.utils.page.OrderBy;
import org.dromara.warm.flow.orm.dao.WarmDaoImpl;
import org.dromara.warm.flow.orm.entity.FlowUser;
import org.dromara.warm.flow.orm.utils.TenantDeleteUtil;

public class FlowUserDaoImpl
extends WarmDaoImpl<FlowUser>
implements FlowUserDao<FlowUser> {
    public FlowUser newEntity() {
        return new FlowUser();
    }

    @Override
    public Class<FlowUser> entityClass() {
        return FlowUser.class;
    }

    public int deleteByTaskIds(List<Long> taskIdList) {
        FlowUser entity = TenantDeleteUtil.getEntity(this.newEntity());
        if (StringUtils.isNotEmpty((String)entity.getDelFlag())) {
            CriteriaUpdate criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "associated", taskIdList));
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "associated", taskIdList));
            if (Objects.nonNull(entity.getTenantId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
            }
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }

    public List<FlowUser> listByAssociatedAndTypes(List<Long> associateds, String[] types) {
        FlowUser entity = TenantDeleteUtil.getEntity(this.newEntity());
        CriteriaQuery criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            if (CollUtil.isNotEmpty((Collection)associateds)) {
                if (associateds.size() == 1) {
                    predicates.add(criteriaBuilder.equal((Expression)root.get("associated"), associateds.get(0)));
                } else {
                    predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "associated", associateds));
                }
            }
            if (ArrayUtil.isNotEmpty((Object[])types)) {
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, (Root)root, "type", (Serializable[])types));
            }
            this.orderBy((CriteriaBuilder)criteriaBuilder, root, innerCriteriaQuery, entity, (OrderBy)null);
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }

    public List<FlowUser> listByProcessedBys(Long associated, List<String> processedBys, String[] types) {
        FlowUser entity = TenantDeleteUtil.getEntity(this.newEntity());
        CriteriaQuery criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            if (associated != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("associated"), (Object)associated));
            }
            if (CollUtil.isNotEmpty((Collection)processedBys)) {
                if (processedBys.size() == 1) {
                    predicates.add(criteriaBuilder.equal((Expression)root.get("processed_by"), processedBys.get(0)));
                } else {
                    predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "processed_by", processedBys));
                }
            }
            if (ArrayUtil.isNotEmpty((Object[])types)) {
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, (Root)root, "type", (Serializable[])types));
            }
            this.orderBy((CriteriaBuilder)criteriaBuilder, root, innerCriteriaQuery, entity, (OrderBy)null);
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }
}

