/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.orm.dao;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;
import java.util.Objects;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.orm.dao.FlowHisTaskDao;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.orm.dao.WarmDaoImpl;
import org.dromara.warm.flow.orm.entity.FlowHisTask;
import org.dromara.warm.flow.orm.utils.TenantDeleteUtil;

public class FlowHisTaskDaoImpl
extends WarmDaoImpl<FlowHisTask>
implements FlowHisTaskDao<FlowHisTask> {
    public FlowHisTask newEntity() {
        return new FlowHisTask();
    }

    @Override
    public Class<FlowHisTask> entityClass() {
        return FlowHisTask.class;
    }

    public List<FlowHisTask> getNoReject(Long instanceId) {
        FlowHisTask entity = TenantDeleteUtil.getEntity(this.newEntity());
        CriteriaQuery criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            predicates.add(criteriaBuilder.equal((Expression)root.get("instanceId"), (Object)instanceId));
            predicates.add(criteriaBuilder.equal((Expression)root.get("skipType"), (Object)SkipType.PASS.getKey()));
            innerCriteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("createTime"))});
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }

    public List<FlowHisTask> getByInsAndNodeCodes(Long instanceId, List<String> nodeCodes) {
        FlowHisTask entity = TenantDeleteUtil.getEntity(this.newEntity());
        CriteriaQuery criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            predicates.add(criteriaBuilder.equal((Expression)root.get("instanceId"), (Object)instanceId));
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "nodeCode", nodeCodes));
            innerCriteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("createTime"))});
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }

    public int deleteByInsIds(List<Long> instanceIds) {
        FlowHisTask entity = TenantDeleteUtil.getEntity(this.newEntity());
        if (StringUtils.isNotEmpty((String)entity.getDelFlag())) {
            CriteriaUpdate criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "instanceId", instanceIds));
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "instanceId", instanceIds));
            if (Objects.nonNull(entity.getTenantId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
            }
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }

    public List<FlowHisTask> listByTaskIdAndCooperateTypes(Long taskId, Integer[] cooperateTypes) {
        FlowHisTask entity = TenantDeleteUtil.getEntity(this.newEntity());
        CriteriaQuery criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            predicates.add(criteriaBuilder.equal((Expression)root.get("taskId"), (Object)taskId));
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, (Root)root, "cooperateType", cooperateTypes));
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }
}

