/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.orm.dao;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.orm.dao.FlowNodeDao;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.orm.dao.WarmDaoImpl;
import org.dromara.warm.flow.orm.entity.FlowNode;
import org.dromara.warm.flow.orm.utils.TenantDeleteUtil;

public class FlowNodeDaoImpl
extends WarmDaoImpl<FlowNode>
implements FlowNodeDao<FlowNode> {
    public FlowNode newEntity() {
        return new FlowNode();
    }

    @Override
    public Class<FlowNode> entityClass() {
        return FlowNode.class;
    }

    public List<FlowNode> getByNodeCodes(List<String> nodeCodes, Long definitionId) {
        FlowNode entity = TenantDeleteUtil.getEntity(this.newEntity());
        CriteriaQuery criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            predicates.add(criteriaBuilder.equal((Expression)root.get("definitionId"), (Object)definitionId));
            if (CollUtil.isNotEmpty((Collection)nodeCodes)) {
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "nodeCode", nodeCodes));
            }
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }

    public int deleteNodeByDefIds(Collection<? extends Serializable> defIds) {
        FlowNode entity = TenantDeleteUtil.getEntity(this.newEntity());
        if (StringUtils.isNotEmpty((String)entity.getDelFlag())) {
            CriteriaUpdate criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "definitionId", defIds));
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "definitionId", defIds));
            if (Objects.nonNull(entity.getTenantId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
            }
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }
}

