/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.orm.dao;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.orm.dao.FlowSkipDao;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.orm.dao.WarmDaoImpl;
import org.dromara.warm.flow.orm.entity.FlowSkip;
import org.dromara.warm.flow.orm.utils.TenantDeleteUtil;

public class FlowSkipDaoImpl
extends WarmDaoImpl<FlowSkip>
implements FlowSkipDao<FlowSkip> {
    public FlowSkip newEntity() {
        return new FlowSkip();
    }

    @Override
    public Class<FlowSkip> entityClass() {
        return FlowSkip.class;
    }

    public int deleteSkipByDefIds(Collection<? extends Serializable> defIds) {
        FlowSkip entity = TenantDeleteUtil.getEntity(this.newEntity());
        if (StringUtils.isNotEmpty((String)entity.getDelFlag())) {
            CriteriaUpdate criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "definitionId", defIds));
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "definitionId", defIds));
            if (Objects.nonNull(entity.getTenantId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
            }
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }
}

