/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.orm.dao;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.List;
import java.util.Objects;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.orm.dao.FlowTaskDao;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.orm.dao.WarmDaoImpl;
import org.dromara.warm.flow.orm.entity.FlowTask;
import org.dromara.warm.flow.orm.utils.TenantDeleteUtil;

public class FlowTaskDaoImpl
extends WarmDaoImpl<FlowTask>
implements FlowTaskDao<FlowTask> {
    public FlowTask newEntity() {
        return new FlowTask();
    }

    @Override
    public Class<FlowTask> entityClass() {
        return FlowTask.class;
    }

    public int deleteByInsIds(List<Long> instanceIds) {
        FlowTask entity = TenantDeleteUtil.getEntity(this.newEntity());
        if (StringUtils.isNotEmpty((String)entity.getDelFlag())) {
            CriteriaUpdate criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "instanceId", instanceIds));
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, root, "instanceId", instanceIds));
            if (Objects.nonNull(entity.getTenantId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
            }
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }
}

