/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.orm.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.orm.agent.WarmQuery;
import org.dromara.warm.flow.core.orm.dao.WarmDao;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.core.utils.page.OrderBy;
import org.dromara.warm.flow.core.utils.page.Page;
import org.dromara.warm.flow.orm.entity.JPARootEntity;
import org.dromara.warm.flow.orm.utils.JPAPredicateFunction;
import org.dromara.warm.flow.orm.utils.JPAQueryFunction;
import org.dromara.warm.flow.orm.utils.JPAUpdateFunction;
import org.dromara.warm.flow.orm.utils.TenantDeleteUtil;

public abstract class WarmDaoImpl<T extends JPARootEntity<T>>
implements WarmDao<T> {
    @PersistenceContext
    protected EntityManager entityManager;

    public abstract Class<T> entityClass();

    public T selectById(Serializable id) {
        JPARootEntity entity = TenantDeleteUtil.getEntity((JPARootEntity)this.newEntity());
        entity.setId((Long)id);
        CriteriaQuery<T> criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates));
        return (T)((JPARootEntity)CollUtil.getOne((List)this.entityManager.createQuery(criteriaQuery).getResultList()));
    }

    public List<T> selectByIds(Collection<? extends Serializable> ids) {
        JPARootEntity entity = TenantDeleteUtil.getEntity((JPARootEntity)this.newEntity());
        CriteriaQuery<T> criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            predicates.add(criteriaBuilder.in((Expression)root.get("id").in(ids)));
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }

    public Page<T> selectPage(T entity, Page<T> page) {
        TenantDeleteUtil.getEntity(entity);
        JPAPredicateFunction<CriteriaBuilder, Root<T>, List<Predicate>> predicateFunction = (criteriaBuilder, root, predicates) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            entity.entityPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
        };
        CriteriaQuery<Long> criteriaCountQuery = this.createCriteriaCountQuery(predicateFunction);
        Long total = (Long)this.entityManager.createQuery(criteriaCountQuery).getSingleResult();
        if (ObjectUtil.isNotNull((Object)total) && total > 0L) {
            CriteriaQuery<T> criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
                predicateFunction.process((CriteriaBuilder)criteriaBuilder, (Root<T>)root, (List<Predicate>)predicates);
                this.orderBy((CriteriaBuilder)criteriaBuilder, (Root<T>)root, (CriteriaQuery<T>)innerCriteriaQuery, entity, (OrderBy)page);
            });
            if (ObjectUtil.isNotNull(page)) {
                return new Page(this.entityManager.createQuery(criteriaQuery).setFirstResult((page.getPageNum() - 1) * page.getPageSize()).setMaxResults(page.getPageSize()).getResultList(), total.longValue());
            }
            return new Page(this.entityManager.createQuery(criteriaQuery).getResultList(), total.longValue());
        }
        return Page.empty();
    }

    public List<T> selectList(T entity, WarmQuery<T> query) {
        TenantDeleteUtil.getEntity(entity);
        CriteriaQuery<T> criteriaQuery = this.createCriteriaQuery((criteriaBuilder, root, predicates, innerCriteriaQuery) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            entity.entityPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            this.orderBy((CriteriaBuilder)criteriaBuilder, (Root<T>)root, (CriteriaQuery<T>)innerCriteriaQuery, entity, (OrderBy)query);
        });
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }

    public long selectCount(T entity) {
        TenantDeleteUtil.getEntity(entity);
        CriteriaQuery<Long> criteriaCountQuery = this.createCriteriaCountQuery((criteriaBuilder, root, predicates) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            entity.entityPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
        });
        return (Long)this.entityManager.createQuery(criteriaCountQuery).getSingleResult();
    }

    public int save(T entity) {
        TenantDeleteUtil.getEntity(entity);
        this.entityManager.persist(entity);
        return 1;
    }

    public int updateById(T entity) {
        Object originEntity = this.selectById(((JPARootEntity)entity).getId());
        ((JPARootEntity)originEntity).entityMerge().merge(entity);
        this.entityManager.persist(originEntity);
        return 1;
    }

    public int delete(T entity) {
        if (StringUtils.isNotEmpty((String)((JPARootEntity)entity).getDelFlag())) {
            CriteriaUpdate<T> criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
                entity.entityPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete<T> criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            entity.commonPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
            entity.entityPredicate().process((CriteriaBuilder)criteriaBuilder, root, (List<Predicate>)predicates);
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }

    public int deleteById(Serializable id) {
        JPARootEntity entity = TenantDeleteUtil.getEntity((JPARootEntity)this.newEntity());
        entity.setId((Long)id);
        if (StringUtils.isNotEmpty((String)entity.getDelFlag())) {
            CriteriaUpdate<T> criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                predicates.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)id));
                if (StringUtils.isNotEmpty((String)entity.getTenantId())) {
                    predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
                }
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete<T> criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            predicates.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)id));
            if (StringUtils.isNotEmpty((String)entity.getTenantId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
            }
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }

    public void saveBatch(List<T> list) {
        for (JPARootEntity record : list) {
            this.save((T)record);
        }
    }

    public void updateBatch(List<T> list) {
        for (JPARootEntity record : list) {
            this.updateById((T)record);
        }
    }

    public int deleteByIds(Collection<? extends Serializable> ids) {
        JPARootEntity entity = TenantDeleteUtil.getEntity((JPARootEntity)this.newEntity());
        if (StringUtils.isNotEmpty((String)entity.getDelFlag())) {
            CriteriaUpdate<T> criteriaUpdate = this.createCriteriaUpdate((criteriaBuilder, root, predicates, innerCriteriaUpdate) -> {
                predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, (Root<T>)root, "id", (Collection)ids));
                if (StringUtils.isNotEmpty((String)entity.getTenantId())) {
                    predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
                }
                innerCriteriaUpdate.set(root.get("delFlag"), (Object)FlowEngine.getFlowConfig().getLogicDeleteValue());
            });
            return this.entityManager.createQuery(criteriaUpdate).executeUpdate();
        }
        CriteriaDelete<T> criteriaDelete = this.createCriteriaDelete((criteriaBuilder, root, predicates) -> {
            predicates.add(this.createIn((CriteriaBuilder)criteriaBuilder, (Root<T>)root, "id", (Collection)ids));
            if (StringUtils.isNotEmpty((String)entity.getTenantId())) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)entity.getTenantId()));
            }
        });
        return this.entityManager.createQuery(criteriaDelete).executeUpdate();
    }

    protected CriteriaQuery<T> createCriteriaQuery(JPAQueryFunction<CriteriaBuilder, Root<T>, List<Predicate>, CriteriaQuery<T>> orderByQueryFunction) {
        Class<T> entityClass = this.entityClass();
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(entityClass);
        Root root = criteriaQuery.from(entityClass);
        ArrayList predicates = new ArrayList();
        orderByQueryFunction.process(criteriaBuilder, root, predicates, criteriaQuery);
        criteriaQuery.where(predicates.toArray(new Predicate[0]));
        return criteriaQuery;
    }

    protected CriteriaQuery<Long> createCriteriaCountQuery(JPAPredicateFunction<CriteriaBuilder, Root<T>, List<Predicate>> predicateFunction) {
        Class<T> entityClass = this.entityClass();
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root rootCount = criteriaQuery.from(entityClass);
        ArrayList predicates = new ArrayList();
        predicateFunction.process(criteriaBuilder, rootCount, predicates);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)rootCount));
        criteriaQuery.where(predicates.toArray(new Predicate[0]));
        return criteriaQuery;
    }

    protected void orderBy(CriteriaBuilder criteriaBuilder, Root<T> root, CriteriaQuery<T> criteriaQuery, T entity, OrderBy orderBy) {
        if (Objects.nonNull(orderBy) && StringUtils.isNotEmpty((String)orderBy.getOrderBy())) {
            String field = ((JPARootEntity)entity).orderByField(orderBy.getOrderBy());
            AssertUtil.isEmpty((Object)field, (String)"OrderBy \u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            if (orderBy.getIsAsc().equals("asc")) {
                criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get(field))});
            } else {
                criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(field))});
            }
        }
    }

    protected <F extends Serializable> CriteriaBuilder.In<F> createIn(CriteriaBuilder criteriaBuilder, Root<T> root, String fieldName, Collection<F> values) {
        CriteriaBuilder.In in = criteriaBuilder.in((Expression)root.get(fieldName));
        for (Serializable value : values) {
            in.value((Object)value);
        }
        return in;
    }

    protected <F extends Serializable> CriteriaBuilder.In<F> createIn(CriteriaBuilder criteriaBuilder, Root<T> root, String fieldName, F[] values) {
        CriteriaBuilder.In in = criteriaBuilder.in((Expression)root.get(fieldName));
        for (F value : values) {
            in.value(value);
        }
        return in;
    }

    protected CriteriaUpdate<T> createCriteriaUpdate(JPAUpdateFunction<CriteriaBuilder, Root<T>, List<Predicate>, CriteriaUpdate<T>> updateFunction) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Class<T> entityClass = this.entityClass();
        CriteriaUpdate criteriaUpdate = criteriaBuilder.createCriteriaUpdate(entityClass);
        Root root = criteriaUpdate.from(entityClass);
        ArrayList predicates = new ArrayList();
        updateFunction.process(criteriaBuilder, root, predicates, criteriaUpdate);
        criteriaUpdate.where(predicates.toArray(new Predicate[0]));
        return criteriaUpdate;
    }

    protected CriteriaDelete<T> createCriteriaDelete(JPAPredicateFunction<CriteriaBuilder, Root<T>, List<Predicate>> predicateFunction) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Class<T> entityClass = this.entityClass();
        CriteriaDelete criteriaDelete = criteriaBuilder.createCriteriaDelete(entityClass);
        Root root = criteriaDelete.from(entityClass);
        ArrayList predicates = new ArrayList();
        predicateFunction.process(criteriaBuilder, root, predicates);
        criteriaDelete.where(predicates.toArray(new Predicate[0]));
        return criteriaDelete;
    }
}

