/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.orm.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.dromara.warm.flow.core.entity.RootEntity;
import org.dromara.warm.flow.orm.utils.JPAPredicateFunction;
import org.dromara.warm.flow.orm.utils.JPAUpdateMergeFunction;
import org.dromara.warm.flow.orm.utils.JPAUtil;

@MappedSuperclass
public abstract class JPARootEntity<T extends RootEntity>
implements RootEntity {
    protected static final HashMap<String, String> JPA_ROOT_ENTITY_MAPPING = new HashMap();
    @Transient
    private JPAPredicateFunction<CriteriaBuilder, Root<T>, List<Predicate>> commonPredicate = (criteriaBuilder, root, predicates) -> {
        if (Objects.nonNull(this.id)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)this.id));
        }
        if (Objects.nonNull(this.createTime)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("createTime"), (Object)this.createTime));
        }
        if (Objects.nonNull(this.updateTime)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("updateTime"), (Object)this.updateTime));
        }
        if (Objects.nonNull(this.delFlag)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("delFlag"), (Object)this.delFlag));
        }
        if (Objects.nonNull(this.tenantId)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("tenantId"), (Object)this.tenantId));
        }
    };
    @Id
    private Long id;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="update_time")
    private Date updateTime;
    @Column(name="tenant_id")
    private String tenantId;
    @Column(name="del_flag")
    private String delFlag;

    public abstract String orderByField(String var1);

    public abstract JPAPredicateFunction<CriteriaBuilder, Root<T>, List<Predicate>> entityPredicate();

    public abstract JPAUpdateMergeFunction<T> entityMerge();

    public abstract void initDefaultValue();

    public JPAPredicateFunction<CriteriaBuilder, Root<T>, List<Predicate>> commonPredicate() {
        return this.commonPredicate;
    }

    public Long getId() {
        return this.id;
    }

    public T setId(Long id) {
        this.id = id;
        return (T)this;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public T setCreateTime(Date createTime) {
        this.createTime = createTime;
        return (T)this;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public T setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        return (T)this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public T setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return (T)this;
    }

    public String getDelFlag() {
        return this.delFlag;
    }

    public T setDelFlag(String delFlag) {
        this.delFlag = delFlag;
        return (T)this;
    }

    public String toString() {
        return "JPARootEntity{id=" + this.id + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", tenantId='" + this.tenantId + "', delFlag='" + this.delFlag + "'}";
    }

    static {
        JPAUtil.initMapping(JPARootEntity.class, JPA_ROOT_ENTITY_MAPPING);
    }
}

