/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.plugin.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.json.JsonConvert;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConvertJackson
implements JsonConvert {
    private static final Logger log = LoggerFactory.getLogger(JsonConvertJackson.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Map<String, Object> strToMap(String jsonStr) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                return (Map)objectMapper.readValue(jsonStr, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class));
            }
            catch (IOException e) {
                log.error("json\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                throw new FlowException("json\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return new HashMap<String, Object>();
    }

    public String mapToStr(Map<String, Object> variable) {
        if (MapUtil.isNotEmpty(variable)) {
            try {
                return objectMapper.writeValueAsString(variable);
            }
            catch (Exception e) {
                log.error("Map\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                throw new FlowException("Map\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return null;
    }
}

