/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.page;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Objects;

public class PageRectangle
implements Serializable {
    private static final long serialVersionUID = -8290831144835083352L;
    private static final Integer DEFAULT_DPI = 72;
    public static final Float POINTS_PER_MM = Float.valueOf(0.03937008f * (float)DEFAULT_DPI.intValue());
    private Integer dpi = DEFAULT_DPI;
    private Float width;
    private Float height;
    public static final PageRectangle A0 = new PageRectangle(841.0f * POINTS_PER_MM.floatValue(), 1189.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A1 = new PageRectangle(594.0f * POINTS_PER_MM.floatValue(), 841.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A2 = new PageRectangle(420.0f * POINTS_PER_MM.floatValue(), 594.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A3 = new PageRectangle(297.0f * POINTS_PER_MM.floatValue(), 420.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A4 = new PageRectangle(210.0f * POINTS_PER_MM.floatValue(), 297.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A5 = new PageRectangle(148.0f * POINTS_PER_MM.floatValue(), 210.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A6 = new PageRectangle(105.0f * POINTS_PER_MM.floatValue(), 148.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A7 = new PageRectangle(74.0f * POINTS_PER_MM.floatValue(), 105.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle A8 = new PageRectangle(52.0f * POINTS_PER_MM.floatValue(), 74.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B0 = new PageRectangle(1030.0f * POINTS_PER_MM.floatValue(), 1456.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B1 = new PageRectangle(728.0f * POINTS_PER_MM.floatValue(), 1030.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B2 = new PageRectangle(515.0f * POINTS_PER_MM.floatValue(), 728.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B3 = new PageRectangle(364.0f * POINTS_PER_MM.floatValue(), 515.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B4 = new PageRectangle(257.0f * POINTS_PER_MM.floatValue(), 364.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B5 = new PageRectangle(182.0f * POINTS_PER_MM.floatValue(), 257.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B6 = new PageRectangle(128.0f * POINTS_PER_MM.floatValue(), 182.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B7 = new PageRectangle(91.0f * POINTS_PER_MM.floatValue(), 128.0f * POINTS_PER_MM.floatValue());
    public static final PageRectangle B8 = new PageRectangle(64.0f * POINTS_PER_MM.floatValue(), 91.0f * POINTS_PER_MM.floatValue());

    private PageRectangle(float width, float height) {
        this.width = Float.valueOf(Math.abs(width));
        this.height = Float.valueOf(Math.abs(height));
    }

    public static PageRectangle create(float width, float height) {
        return new PageRectangle(width, height);
    }

    public static Rectangle getRotateRectangle(int width, int height, double radians) {
        Rectangle src = new Rectangle(new Dimension(width, height));
        int angle = 90;
        int num = 2;
        if (radians < 0.0) {
            radians += 360.0;
        }
        if (radians % 360.0 == 0.0) {
            return src;
        }
        if (radians >= 90.0) {
            if (radians / 90.0 % 2.0 == 1.0) {
                return new Rectangle((int)src.getHeight(), (int)src.getWidth());
            }
            radians %= 90.0;
        }
        double radius = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(radians) / 2.0) * radius;
        double radiansAlpha = (Math.PI - Math.toRadians(radians)) / 2.0;
        double radiansWidth = Math.atan((double)src.height / (double)src.width);
        double radiansHeight = Math.atan((double)src.width / (double)src.height);
        int lenWidth = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansWidth)));
        int lenHeight = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansHeight)));
        return new Rectangle(src.width + lenWidth * 2, src.height + lenHeight * 2);
    }

    public PageRectangle setDpi(int dpi) {
        this.dpi = Math.abs(dpi);
        this.width = Float.valueOf(this.width.floatValue() * (float)this.dpi.intValue() / (float)DEFAULT_DPI.intValue());
        this.height = Float.valueOf(this.height.floatValue() * (float)this.dpi.intValue() / (float)DEFAULT_DPI.intValue());
        return this;
    }

    public PageRectangle changeLandscape() {
        return new PageRectangle(this.height.floatValue(), this.width.floatValue());
    }

    public float getUnit() {
        if (Objects.equals(this.dpi, DEFAULT_DPI)) {
            return POINTS_PER_MM.floatValue();
        }
        return POINTS_PER_MM.floatValue() * (float)this.dpi.intValue() / (float)DEFAULT_DPI.intValue();
    }

    public float getWidth() {
        return this.width.floatValue();
    }

    public float getHeight() {
        return this.height.floatValue();
    }
}

