/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.text.Text;
import org.dromara.pdf.fop.core.doc.component.text.TextBase;
import org.dromara.pdf.fop.core.doc.component.text.TextExtendParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TextExtend
extends TextBase {
    private final TextExtendParam param = new TextExtendParam();

    private TextExtend setInitialCapacity(int initialCapacity) {
        this.param.setTextList(new ArrayList<Text>(initialCapacity));
        return this;
    }

    public TextExtend setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public TextExtend setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public TextExtend setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public TextExtend setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public TextExtend setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public TextExtend setId(String id) {
        this.param.setId(id);
        return this;
    }

    public TextExtend setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public TextExtend setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public TextExtend setLetterSpacing(String letterSpacing) {
        this.param.setLetterSpacing(letterSpacing);
        return this;
    }

    public TextExtend setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public TextExtend setTextIndent(String indent) {
        this.param.setTextIndent(indent);
        return this;
    }

    public TextExtend setStartIndent(String indent) {
        this.param.setStartIndent(indent);
        return this;
    }

    public TextExtend setEndIndent(String indent) {
        this.param.setEndIndent(indent);
        return this;
    }

    public TextExtend setSpaceBefore(String space) {
        this.param.setSpaceBefore(space);
        return this;
    }

    public TextExtend setSpaceAfter(String space) {
        this.param.setSpaceAfter(space);
        return this;
    }

    public TextExtend setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public TextExtend setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public TextExtend setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public TextExtend setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public TextExtend setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public TextExtend setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public TextExtend setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public TextExtend setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public TextExtend setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public TextExtend setTextSpacing(String spacing) {
        this.param.setTextSpacing(spacing);
        return this;
    }

    public TextExtend setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public TextExtend enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public TextExtend enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public TextExtend enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public TextExtend enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    public TextExtend addText(Text ... texts) {
        Optional.ofNullable(texts).ifPresent(v -> Collections.addAll(this.param.getTextList(), v));
        return this;
    }

    public TextExtend addText(List<Text> texts) {
        Optional.ofNullable(texts).ifPresent(this.param.getTextList()::addAll);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getTextList() == null) {
            return null;
        }
        Element block = this.initBlock(document, this.param);
        List<Text> textList = this.param.getTextList();
        int lastIndex = textList.size() - 1;
        int size = textList.size();
        for (int i = 0; i < size; ++i) {
            int index = i;
            Optional.ofNullable(textList.get(i).init(this.param).createElement(document)).ifPresent(e -> {
                block.appendChild(e.getFirstChild());
                if (index < lastIndex) {
                    Optional.ofNullable(this.param.getTextSpacing()).ifPresent(l -> {
                        Element leader = document.createElement("fo:leader");
                        leader.setAttribute("leader-length", l.intern().toLowerCase());
                        block.appendChild(leader);
                    });
                }
            });
        }
        return block;
    }
}

