/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.util;

import java.awt.Font;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import lombok.Generated;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.dromara.pdf.fop.support.font.FontInfoHelper;
import org.dromara.pdf.fop.util.FontStyleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FontUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Font createAWTFont(String name, FontStyleUtil.FontStyle style, int size) {
        InputStream inputStream = null;
        try {
            FontInfo fontInfo = FontInfoHelper.get();
            if (Objects.isNull(fontInfo)) {
                Font font = new Font(name, style.getAwtStyle(), size);
                return font;
            }
            FontTriplet triplet = fontInfo.findAdjustWeight(name, style.getStyle(), style.getWeight());
            org.apache.fop.fonts.Font font = fontInfo.getFontInstance(triplet, size);
            if (font.getFontTriplet().equals((Object)org.apache.fop.fonts.Font.DEFAULT_FONT)) {
                Font font2 = new Font(null, style.getAwtStyle(), size);
                return font2;
            }
            try {
                URI uri = font.getFontMetrics().getFontURI();
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri.getPath());
                if (Objects.isNull(inputStream)) {
                    inputStream = Files.newInputStream(Paths.get(uri), new OpenOption[0]);
                }
            }
            catch (Exception e) {
                log.warn("the font['" + name + "'] can not be found, use default font");
                Font font3 = new Font(null, style.getAwtStyle(), size);
                if (!Objects.nonNull(inputStream)) return font3;
                inputStream.close();
                return font3;
            }
            Font font4 = Font.createFont(0, inputStream).deriveFont(style.getAwtStyle(), size);
            return font4;
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                inputStream.close();
            }
        }
    }
}

