/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.core.doc.component.line;

import java.util.Optional;
import org.dromara.pdf.fop.core.doc.component.Component;
import org.dromara.pdf.fop.core.doc.component.line.SplitLineParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SplitLine
implements Component {
    private final SplitLineParam param = new SplitLineParam();

    public SplitLine setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public SplitLine setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public SplitLine setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public SplitLine setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public SplitLine setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public SplitLine setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public SplitLine setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public SplitLine setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public SplitLine setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public SplitLine setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public SplitLine setId(String id) {
        this.param.setId(id);
        return this;
    }

    public SplitLine setLength(String length) {
        this.param.setLength(length);
        return this;
    }

    public SplitLine setStyle(String style) {
        this.param.setStyle(style);
        return this;
    }

    public SplitLine setColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public SplitLine setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public SplitLine setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public SplitLine setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public SplitLine enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public SplitLine enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public SplitLine enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public SplitLine enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element block = this.createBlockElement(document, this.param);
        block.appendChild(this.createLeader(document));
        return block;
    }

    public Element createLeader(Document document) {
        Element leader = document.createElement("fo:leader");
        Optional.ofNullable(this.param.getLength()).ifPresent(v -> leader.setAttribute("leader-length", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getStyle()).ifPresent(v -> {
            if ("dotted".equalsIgnoreCase((String)v)) {
                leader.setAttribute("leader-pattern", "dots");
            } else {
                leader.setAttribute("leader-pattern", "rule");
                leader.setAttribute("rule-style", v.intern().toLowerCase());
            }
        });
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> leader.setAttribute("color", v.intern().toLowerCase()));
        return leader;
    }
}

