/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.datasource;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.resolve.ResourceCodeResolver;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.dromara.pdf.fop.datasource.XEasyPdfTemplateAbstractDataSource;

public class XEasyPdfTemplateJteDataSource
extends XEasyPdfTemplateAbstractDataSource {
    private static final Map<String, TemplateEngine> ENGINE_CACHE = new HashMap<String, TemplateEngine>(10);
    private static final Object LOCK = new Object();

    public XEasyPdfTemplateJteDataSource setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
        return this;
    }

    public XEasyPdfTemplateJteDataSource setTemplateData(Map<String, Object> templateData) {
        this.templateData = templateData;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected InputStream processTemplate() {
        try (StringOutput output = new StringOutput();){
            if (Thread.currentThread().getContextClassLoader().getResource(this.templatePath) == null) {
                this.getTemplateEngine().render(Paths.get(this.templatePath, new String[0]).getFileName().toString(), this.templateData, (TemplateOutput)output);
            } else {
                this.getTemplateEngine().render(this.templatePath, this.templateData, (TemplateOutput)output);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(output.toString().getBytes()));
            return bufferedInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateEngine getTemplateEngine() {
        TemplateEngine engine = ENGINE_CACHE.get(this.templatePath);
        if (engine == null) {
            Object object = LOCK;
            synchronized (object) {
                engine = ENGINE_CACHE.get(this.templatePath);
                if (engine == null) {
                    Object resolver = Thread.currentThread().getContextClassLoader().getResource(this.templatePath) == null ? new DirectoryCodeResolver(Paths.get(this.templatePath, new String[0]).getParent()) : new ResourceCodeResolver(".", Thread.currentThread().getContextClassLoader());
                    engine = TemplateEngine.create((CodeResolver)resolver, (ContentType)ContentType.Html);
                    ENGINE_CACHE.put(this.templatePath, engine);
                }
            }
        }
        return engine;
    }
}

