/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.doc.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.doc.component.table.XEasyPdfTemplateTableRow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XEasyPdfTemplateTableBody {
    private List<XEasyPdfTemplateTableRow> rows = new ArrayList<XEasyPdfTemplateTableRow>(10);
    private String minColumnWidth;
    private String minRowHeight;

    private XEasyPdfTemplateTableBody setInitialCapacity(int initialCapacity) {
        this.rows = new ArrayList<XEasyPdfTemplateTableRow>(initialCapacity);
        return this;
    }

    public XEasyPdfTemplateTableBody setMinRowHeight(String minRowHeight) {
        if (this.minRowHeight == null) {
            this.minRowHeight = minRowHeight;
        }
        return this;
    }

    public XEasyPdfTemplateTableBody setMinColumnWidth(String minColumnWidth) {
        if (this.minColumnWidth == null) {
            this.minColumnWidth = minColumnWidth;
        }
        return this;
    }

    public XEasyPdfTemplateTableBody addRow(XEasyPdfTemplateTableRow ... rows) {
        Optional.ofNullable(rows).ifPresent(v -> Collections.addAll(this.rows, v));
        return this;
    }

    public XEasyPdfTemplateTableBody addRow(List<XEasyPdfTemplateTableRow> rows) {
        Optional.ofNullable(rows).ifPresent(this.rows::addAll);
        return this;
    }

    public List<XEasyPdfTemplateTableRow> getRows() {
        return this.rows;
    }

    public Element createElement(Document document) {
        Element tableBody = document.createElement("fo:table-body");
        for (XEasyPdfTemplateTableRow row : this.rows) {
            tableBody.appendChild(row.setMinColumnWidth(this.minColumnWidth).setMinRowHeight(this.minRowHeight).createElement(document));
        }
        return tableBody;
    }
}

