/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.doc.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dromara.pdf.fop.doc.component.table.XEasyPdfTemplateTableRow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XEasyPdfTemplateTableHeader {
    private List<XEasyPdfTemplateTableRow> rows = new ArrayList<XEasyPdfTemplateTableRow>(10);
    private String minColumnWidth;
    private String minRowHeight;

    private XEasyPdfTemplateTableHeader setInitialCapacity(int initialCapacity) {
        this.rows = new ArrayList<XEasyPdfTemplateTableRow>(initialCapacity);
        return this;
    }

    public XEasyPdfTemplateTableHeader setMinRowHeight(String minRowHeight) {
        if (this.minRowHeight == null) {
            this.minRowHeight = minRowHeight;
        }
        return this;
    }

    public XEasyPdfTemplateTableHeader setMinColumnWidth(String minColumnWidth) {
        if (this.minColumnWidth == null) {
            this.minColumnWidth = minColumnWidth;
        }
        return this;
    }

    public XEasyPdfTemplateTableHeader addRow(XEasyPdfTemplateTableRow ... rows) {
        Optional.ofNullable(rows).ifPresent(v -> Collections.addAll(this.rows, v));
        return this;
    }

    public XEasyPdfTemplateTableHeader addRow(List<XEasyPdfTemplateTableRow> rows) {
        Optional.ofNullable(rows).ifPresent(this.rows::addAll);
        return this;
    }

    public List<XEasyPdfTemplateTableRow> getRows() {
        return this.rows;
    }

    public Element createElement(Document document) {
        Element tableHeader = document.createElement("fo:table-header");
        for (XEasyPdfTemplateTableRow row : this.rows) {
            tableHeader.appendChild(row.setMinColumnWidth(this.minColumnWidth).setMinRowHeight(this.minRowHeight).createElement(document));
        }
        return tableHeader;
    }
}

