/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.fop.doc.watermark;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.util.UnitConv;
import org.dromara.pdf.fop.doc.page.XEasyPdfTemplatePageRectangle;
import org.dromara.pdf.fop.doc.watermark.XEasyPdfTemplateWatermarkComponent;
import org.dromara.pdf.fop.doc.watermark.XEasyPdfTemplateWatermarkParam;
import org.dromara.pdf.fop.util.XEasyPdfTemplateFontStyleUtil;
import org.dromara.pdf.fop.util.XEasyPdfTemplateImageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XEasyPdfTemplateWatermark
implements XEasyPdfTemplateWatermarkComponent {
    private final XEasyPdfTemplateWatermarkParam param = new XEasyPdfTemplateWatermarkParam();
    private static final Map<String, String> CACHE = new HashMap<String, String>(10);
    private static final Object LOCK = new Object();

    public XEasyPdfTemplateWatermark setTempDir(String tempDir) {
        Optional.ofNullable(tempDir).ifPresent(this.param::setTempDir);
        return this;
    }

    public XEasyPdfTemplateWatermark setId(String id) {
        this.param.setId(id);
        return this;
    }

    public XEasyPdfTemplateWatermark setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public XEasyPdfTemplateWatermark setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public XEasyPdfTemplateWatermark setShowWidth(String width) {
        this.param.setShowWidth(width);
        return this;
    }

    public XEasyPdfTemplateWatermark setShowHeight(String height) {
        this.param.setShowHeight(height);
        return this;
    }

    public XEasyPdfTemplateWatermark setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public XEasyPdfTemplateWatermark setFontStyle(String fontStyle) {
        Optional.ofNullable(fontStyle).ifPresent(this.param::setFontStyle);
        return this;
    }

    public XEasyPdfTemplateWatermark setFontSize(String fontSize) {
        Optional.ofNullable(fontSize).ifPresent(this.param::setFontSize);
        return this;
    }

    public XEasyPdfTemplateWatermark setFontColor(String color) {
        Optional.ofNullable(color).ifPresent(this.param::setFontColor);
        return this;
    }

    public XEasyPdfTemplateWatermark setFontAlpha(String alpha) {
        this.param.setFontAlpha(alpha);
        return this;
    }

    public XEasyPdfTemplateWatermark setPosition(String position) {
        this.param.setPosition(position);
        return this;
    }

    public XEasyPdfTemplateWatermark setHorizontalPosition(String position) {
        this.param.setPositionHorizontal(position);
        return this;
    }

    public XEasyPdfTemplateWatermark setVerticalPosition(String position) {
        this.param.setPositionVertical(position);
        return this;
    }

    public XEasyPdfTemplateWatermark setRepeat(String repeat) {
        this.param.setRepeat(repeat);
        return this;
    }

    public XEasyPdfTemplateWatermark setRadians(String radians) {
        Optional.ofNullable(radians).ifPresent(this.param::setRadians);
        return this;
    }

    public XEasyPdfTemplateWatermark enableOverwrite() {
        this.param.setIsOverwrite(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplateWatermark setText(String ... texts) {
        Optional.ofNullable(texts).ifPresent(v -> Collections.addAll(this.param.getTexts(), v));
        return this;
    }

    public XEasyPdfTemplateWatermark setText(List<String> texts) {
        Optional.ofNullable(texts).ifPresent(this.param.getTexts()::addAll);
        return this;
    }

    public void saveImage() {
        this.getImageFile();
    }

    @Override
    public void createWatermark(Document document, Element element) {
        if (element == null) {
            return;
        }
        if (this.param.getTexts().isEmpty()) {
            return;
        }
        element.setAttribute("background-image", this.getImageUrl().intern());
        Optional.ofNullable(this.param.getShowWidth()).ifPresent(v -> element.setAttribute("fox:background-image-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getShowHeight()).ifPresent(v -> element.setAttribute("fox:background-image-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPosition()).ifPresent(v -> element.setAttribute("background-position", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPositionHorizontal()).ifPresent(v -> element.setAttribute("background-position-horizontal", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPositionVertical()).ifPresent(v -> element.setAttribute("background-position-vertical", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getRepeat()).ifPresent(v -> element.setAttribute("background-repeat", v.intern().toLowerCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImageUrl() {
        String url = CACHE.get(this.param.getId());
        if (url == null) {
            Object object = LOCK;
            synchronized (object) {
                url = CACHE.get(this.param.getId());
                if (url == null) {
                    url = this.putCache();
                }
            }
        }
        return url;
    }

    private String putCache() {
        File file = this.getImageFile();
        String url = "url('" + file.toURI().getPath() + "')";
        CACHE.put(this.param.getId(), url);
        return url;
    }

    private File getImageFile() {
        File file = new File(this.param.getTempDir(), this.param.getId() + ".png");
        if (!file.exists() || this.param.getIsOverwrite().booleanValue()) {
            Optional.ofNullable(this.param.getId()).orElseThrow(() -> new IllegalArgumentException("the watermark id can not be null"));
            Optional.ofNullable(this.param.getWidth()).orElseThrow(() -> new IllegalArgumentException("the watermark width can not be null"));
            Optional.ofNullable(this.param.getHeight()).orElseThrow(() -> new IllegalArgumentException("the watermark height can not be null"));
            BufferedImage image = this.createImage();
            ImageIO.write((RenderedImage)image, "png", file);
            image.flush();
        }
        return file;
    }

    private BufferedImage createImage() {
        int width = this.parseUnit(this.param.getWidth());
        int height = this.parseUnit(this.param.getHeight());
        int fontSize = this.parseUnit(this.param.getFontSize());
        Color fontColor = ColorUtil.parseColorString(null, (String)this.param.getFontColor());
        int fontAlpha = Optional.ofNullable(this.param.getFontAlpha()).map(Integer::parseInt).orElse(fontColor.getAlpha());
        double radians = Double.parseDouble(this.param.getRadians());
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics.setColor(new Color(fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue(), fontAlpha));
        graphics.setFont(new Font(this.param.getFontFamily(), XEasyPdfTemplateFontStyleUtil.getStyle(this.param.getFontStyle()), fontSize));
        List<String> texts = this.param.getTexts();
        int beginY = (height - fontSize * texts.size()) / 2 + fontSize;
        for (String word : texts) {
            int wordWidth = graphics.getFontMetrics().stringWidth(word);
            int beginX = (width - wordWidth) / 2;
            graphics.drawString(word, beginX, beginY);
            beginY += fontSize;
        }
        graphics.dispose();
        return XEasyPdfTemplateImageUtil.rotate(image, XEasyPdfTemplatePageRectangle.getRotateRectangle(width, height, radians), radians);
    }

    private int parseUnit(String unit) {
        return UnitConv.convert((String)unit) / 1000;
    }
}

